;Ŀ
;Mouse sensitivity switcher (SenseTSR v1.3b) Copyright (c) 1996 by Virtuoso.
;                                                                           
;  20/01/96 (1.0a) - implementation.                                        
;  28/01/96 (1.1b) - rewrite as it didn't work with SIRDOOM :(              
;  30/01/96 (1.1c) - added new coding for detecting the pressing of our     
;                    keys, checked for a mouse driver, cosmetic changes!    
;  06/02/96 (1.2c) - added new coding for redefining our keys.              
;  17/02/96 (1.3b) - added new coding so as to only look at the keyboard    
;                    every  second, cosmetic changes! also i've changed    
;                    the default sensitivity values.                        
;

MultiplexID             equ     0C0h ; our multiplex id
InstallCheck            equ     0FFh ; installation check function

GetTablePtr             equ     0FEh ; get table ptr function
SetIncreaseKey          equ     0FDh ; set the increase key
SetDecreaseKey          equ     0FCh ; set the decrease key

MaxSensitivityLevel     equ     9 ; max no of sensitivity levels

                        .286
                        .model  tiny
                        .code

Start:
                        jmp     Install

SavedInt1C              dw      0, 0
SavedInt2F              dw      0, 0
SavedInt33              dw      0, 0

SavedAX                 dw      0
SavedBX                 dw      0
SavedCX                 dw      0
SavedDX                 dw      0
SavedSI                 dw      0
SavedDI                 dw      0
SavedBP                 dw      0
SavedDS                 dw      0
SavedES                 dw      0

; SetSense assumes that from here...

SensitivityLevel        db      7
SensitivityTable        db      15, 15, 20, 20, 25, 25
                        db      30, 30, 35, 35, 40, 40
                        db      45, 45, 50, 50, 55, 55

IncreaseKey             db      73 ; PageUp
DecreaseKey             db      81 ; PageDown

; to here is all one area of memory (it makes references from the start).

SoundDelay              db      0
SoundTable              dw      9121, 8609, 8126
                        dw      7670, 7239, 6833
                        dw      6449, 6087, 5746

IncreasePressed         db      0
SensitivityIncreased    db      0
DecreasePressed         db      0
SensitivityDecreased    db      0

KeyboardCheckingDelay   db      0
;
SaveRegisters:
                        mov     cs:[SavedAX], ax
                        mov     cs:[SavedBX], bx
                        mov     cs:[SavedCX], cx
                        mov     cs:[SavedDX], dx
                        mov     cs:[SavedSI], si
                        mov     cs:[SavedDI], di
                        mov     cs:[SavedBP], bp
                        mov     cs:[SavedDS], ds
                        mov     cs:[SavedES], es
                        ret
;
LoadRegisters:
                        mov     ax, cs:[SavedAX]
                        mov     bx, cs:[SavedBX]
                        mov     cx, cs:[SavedCX]
                        mov     dx, cs:[SavedDX]
                        mov     si, cs:[SavedSI]
                        mov     di, cs:[SavedDI]
                        mov     bp, cs:[SavedBP]
                        mov     ds, cs:[SavedDS]
                        mov     es, cs:[SavedES]
                        ret
;
IncreaseSensitivity:
                        call    SaveRegisters

                        cmp     cs:[SensitivityLevel], MaxSensitivityLevel
                        jnz     @@MaxNotReached
                        jmp     @@MaxWasReached
@@MaxNotReached:
                        inc     cs:[SensitivityLevel]
                        call    SetSensitivityLevel
@@MaxWasReached:
                        call    LoadRegisters

                        ret
;
DecreaseSensitivity:
                        call    SaveRegisters

                        cmp     cs:[SensitivityLevel], 1
                        jg      @@MinNotReached
                        jmp     @@MinWasReached
@@MinNotReached:
                        dec     cs:[SensitivityLevel]
                        call    SetSensitivityLevel
@@MinWasReached:
                        call    LoadRegisters
                        ret
;
SetSensitivityLevel:
                        xor     ah, ah
                        mov     al, cs:[SensitivityLevel]
                        dec     al
                        shl     al, 1

                        mov     bx, offset SoundTable
                        add     ax, bx
                        mov     bp, ax

                        mov     bx, cs:[bp]
                        mov     cl, 2

                        call    SensitivitySound

                        mov     ax, 0001Bh
                        pushf
                        call    dword ptr cs:[SavedInt33]

                        xor     ah, ah
                        mov     al, cs:[SensitivityLevel]
                        dec     al
                        shl     al, 1

                        mov     bx, offset SensitivityTable
                        add     ax, bx
                        mov     bp, ax

                        xor     bh, bh
                        xor     ch, ch
                        mov     bl, cs:[bp]
                        mov     cl, cs:[bp+1]

                        mov     ax, 0001Ah
                        pushf
                        call    dword ptr cs:[SavedInt33]

                        ret
;
SensitivitySound:
                        mov     al, 0B6h
                        out     043h, al

                        mov     al, bl
                        out     042h, al
                        mov     al, bh
                        out     042h, al

                        in      al, 061h
                        or      al, 00000011b
                        out     061h, al

                        mov     cs:[SoundDelay], cl
@@SoundDelay:
                        cmp     cs:[SoundDelay], 0
                        jnz     @@SoundDelay
                                                                        
                        in      al, 061h
                        and     al, 11111100b
                        out     061h, al

                        ret
;
NewInt1C:
                        push    ax
                        sti

                        cmp     cs:[SoundDelay], 0
                        jz      @@NoSound

                        dec     cs:[SoundDelay]
@@NoSound:
                        inc     cs:[KeyboardCheckingDelay]
                        cmp     cs:[KeyboardCheckingDelay], 9
                        jnz     @@Int1CEnd

                        mov     cs:[KeyboardCheckingDelay], 0

                        cmp     cs:[SensitivityIncreased], 0
                        jnz     @@Int1CEnd
                        cmp     cs:[SensitivityDecreased], 0
                        jnz     @@Int1CEnd

                        in      al, 060h
                        cmp     al, cs:[IncreaseKey]
                        jz      @@IncreaseHit
                        cmp     al, cs:[DecreaseKey]
                        jz      @@DecreaseHit
                        jmp     @@Int1CEnd
@@IncreaseHit:
                        mov     cs:[SensitivityIncreased], 1
                        jmp     @@Int1CEnd
@@DecreaseHit:
                        mov     cs:[SensitivityDecreased], 1
@@Int1CEnd:
                        pop     ax
                        jmp     dword ptr cs:[SavedInt1C]

;
NewInt2F:
                        cmp     ah, MultiplexID
                        jz      @@OurMultiplexID

                        jmp     dword ptr cs:[SavedInt2F]
@@OurMultiplexID:
                        cmp     al, InstallCheck
                        jz      @@InstallCheck
                        cmp     al, GetTablePtr
                        jz      @@GetTablePtr
                        cmp     al, SetIncreaseKey
                        jz      @@SetIncreaseKey
                        cmp     al, SetDecreaseKey
                        jz      @@SetDecreaseKey

                        jmp     dword ptr cs:[SavedInt2F]
@@InstallCheck:
                        xchg    ah, al
                        mov     dx, seg Message
                        mov     es, dx
                        mov     si, offset Message
                        jmp     @@Int2FEnd
@@GetTablePtr:
                        mov     dx, seg SensitivityTable
                        mov     ds, dx
                        mov     dx, offset SensitivityTable
                        jmp     @@Int2FEnd
@@SetIncreaseKey:
                        mov     cs:[IncreaseKey], cl
                        jmp     @@Int2FEnd
@@SetDecreaseKey:
                        mov     cs:[DecreaseKey], cl
@@Int2FEnd:
                        iret
;
NewInt33:
                        cmp     ax, 00003h
                        jz      @@ChangedSensitivity

                        jmp     dword ptr cs:[SavedInt33]
@@ChangedSensitivity:
                        cmp     cs:[SensitivityIncreased], 1
                        jz      @@IncreaseDown
                        cmp     cs:[SensitivityDecreased], 1
                        jz      @@DecreaseDown
                        jmp     @@Int33End
@@IncreaseDown:
                        sti
                        dec     cs:[SensitivityIncreased]
                        call    IncreaseSensitivity
                        jmp     @@Int33End
@@DecreaseDown:
                        sti
                        dec     cs:[SensitivityDecreased]
                        call    DecreaseSensitivity
                        jmp     @@Int33End
@@Int33End:
                        jmp     dword ptr cs:[SavedInt33]
;
Install:
                        mov     ah, 009h
                        mov     dx, seg Message
                        mov     ds, dx
                        mov     dx, offset Message
                        int     021h

                        xor     ax, ax
                        int     033h

                        cmp     AX, 0FFFFh
                        jz      @@MouseDriverInstalled

                        mov     ah, 009h
                        mov     dx, seg NoMouseDriver
                        mov     ds, dx
                        mov     dx, offset NoMouseDriver
                        int     021h

                        mov     ax, 04C01h
                        int     021h
@@MouseDriverInstalled:
                        mov     ah, MultiplexID
                        mov     al, InstallCheck
                        int     02Fh

                        cmp     ah, InstallCheck
                        jnz     @@NotInstalled
                        cmp     al, MultiplexID
                        jnz     @@NotInstalled

                        mov     cx, 26
                        mov     ax, seg Message
                        mov     ds, ax
                        mov     di, offset Message
@@CheckForMessage:
                        mov     ah, es:[si]
                        mov     al, ds:[di]
                        cmp     ah, al
                        jnz     @@NotInstalled
                        inc     bx
                        inc     dx
                        loopnz  @@CheckForMessage

                        mov     ah, 009h
                        mov     dx, seg AlreadyInstalled
                        mov     ds, dx
                        mov     dx, offset AlreadyInstalled
                        int     021h

                        mov     ax, 04C01h
                        int     021h
@@NotInstalled:
                        mov     ax, 0351Ch
                        int     021h
                        mov     cs:[SavedInt1C], BX
                        mov     cs:[SavedInt1C+2], ES

                        mov     ax, 0251Ch
                        mov     dx, seg NewInt1C
                        mov     ds, dx
                        mov     dx, offset NewInt1C
                        int     021h

                        mov     ax, 0352Fh
                        int     021h
                        mov     cs:[SavedInt2F], BX
                        mov     cs:[SavedInt2F+2], ES

                        mov     ax, 0252Fh
                        mov     dx, seg NewInt2F
                        mov     ds, dx
                        mov     dx, offset NewInt2F
                        int     021h
        
                        mov     ax, 03533h
                        int     021h
                        mov     cs:[SavedInt33], BX
                        mov     cs:[SavedInt33+2], ES

                        mov     ax, 02533h
                        mov     dx, seg NewInt33
                        mov     ds, dx
                        mov     dx, offset NewInt33
                        int     021h

                        mov     ah, 009h
                        mov     dx, seg Installed
                        mov     ds, dx
                        mov     dx, offset Installed
                        int     021h

                        call    SetSensitivityLevel

                        ; dunno why this doesn't work out the exact
                        ; paragraphs so if you do then please tell me!

        		mov     dx, offset Install
                        add     dx, 15
                        shr     dx, 4

                        add     dx, dx ; double the paras to make sure :)

                        mov     ax, 03100h
                        int     021h

Message                 db      'Mouse sensitivity switcher (SenseTSR v1.3b)'
                        db      ', Copyright (c) 1996 by Virtuoso.'
                        db      00Ah, 00Dh
                        db      'Use PgUp/PgDn (default keys) to switch '
                        db      'between the nine levels of sensitivity.'
                        db      00Ah, 00Dh, 00Ah, '$'

NoMouseDriver           db      'Mouse driver is not installed!', 00Ah, 00Dh, '$'

Installed               db      'Installed.', 00Ah, 00Dh, '$'
AlreadyInstalled        db      'Already installed!', 00Ah, 00Dh, '$'

                        end     Start
