program SetSense;

{
Ŀ
Mouse sensitivity switcher (SetSense v1.3b) Copyright (c) 1996 by Virtuoso.
                                                                           
  20/01/96 (1.0a) - implementation.                                        
  28/01/96 (1.1b) - rewrite as it didn't work with SIRDOOM :(              
  30/01/96 (1.1c) - new version.                                           
  06/02/96 (1.2c) - added new coding for redefining our keys.              
  17/02/96 (1.3b) - added new coding for changing the sensitivity level.   

}

uses
  dos;

const
  cVersion: string = 'Mouse sensitivity switcher (SetSense v1.3b), Copyright (c) 1996 by Virtuoso.';

  nMultiplexID:    byte = $C0;
  nInstallCheck:   byte = $FF;
  nGetTablePtr:    byte = $FE;
  nSetIncreaseKey: byte = $FD;
  nSetDecreaseKey: byte = $FC;

  cParameterLine: string = chr(255);

  aKeys: array[$01..$57] of string =
     ( 'Esc', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', 
       'Backspace', 'Tab', 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 
       '[', ']', 'Enter', 'Ctrl', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 
       'L', ';', '''', '`', 'Left Shift', '\', 'Z', 'X', 'C', 'V', 'B', 'N',
       'M', ',', '.', '/', 'Right Shift', 'Grey*', 'Alt', 'SpaceBar', 
       'CapsLock', 'F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 
       'F10', 'NumLock', 'ScrollLock', 'Home', 'UpArrow', 'PgUp', 'Grey-', 
       'LeftArrow', 'Keypad 5', 'RightArrow', 'Grey+', 'End', 'DownArrow', 
       'PgDn', 'Ins', 'Del', 'SysRq', 'left \', 'F11', 'F12');

var
  r: registers;
  nHS, nVS: byte;
  n: integer;
  nLevel: byte;
  nIncKey, nDecKey: byte;


function IsParameter(cSearchStr: string): integer;

var
  n: integer;

begin
  if cParameterLine = chr(255) then
  begin
    cParameterLine := '';
    for n := 1 to paramcount do
      cParameterLine := cParameterLine + paramstr(n);
  end;

  IsParameter := pos(cSearchStr, cParameterLine);
end;


procedure GetSensitivity(nPos: integer; var nHS, nVS: byte);

var
  cHS, cVS: string[3];

begin
  cHS := '';
  while (cParameterLine[nPos] in ['0'..'9']) and (length(cHS) < 3) do
  begin
    cHS := cHS + cParameterLine[nPos];
    inc(nPos);
  end;

  { ignore the comma }
  inc(nPos);

  cVS := '';
  while (cParameterLine[nPos] in ['0'..'9']) and (length(cVS) < 3) do
  begin
    cVS := cVS + cParameterLine[nPos];
    inc(nPos);
  end;

  { store horizontal and vertical speed }
  val(cHS, nHS, nPos);
  val(cVS, nVS, nPos);
end;


function GetLevel(nPos: integer): byte;

var
  cLevel: string[1];
  nLevel: byte;

begin
  cLevel := cParameterLine[nPos];
  val(cLevel, nLevel, nPos);
  GetLevel := nLevel;
end;


procedure SetMouseSensitivity(nHS, nVS: byte);

var
  r: registers;

begin
  r.AX := $001B;
  intr($33, r);

  r.BX := nHS;
  r.CX := nVS;

  r.AX := $001A;
  intr($33, r);
end;


function GetScanCode(nPos: integer): byte;

var
  cKey: string[3];
  nKey: byte;

begin
  cKey := '';
  while (cParameterLine[nPos] in ['0'..'9']) and (length(cKey) < 2) do
  begin
    cKey := cKey + cParameterLine[nPos];
    inc(nPos);
  end;
  val(cKey, nKey, nPos);

  GetScanCode := nKey;
end;


procedure SetIncreaseKey(nKey: byte);

var
  r: registers;

begin
  r.AH := nMultiplexID;
  r.AL := nSetIncreaseKey;
  r.CL := nKey;

  intr($2F, r);
end;


procedure SetDecreaseKey(nKey: byte);

var
  r: registers;

begin
  r.AH := nMultiplexID;
  r.AL := nSetDecreaseKey;
  r.CL := nKey;

  intr($2F, r);
end;


begin
  writeln(cVersion);
  writeln;

  r.AH := nMultiplexID;
  r.AL := nInstallCheck;
  intr($2F, r);

  if not ((r.AH = nInstallCheck) and (r.AL = nMultiplexID)) then
  begin
    writeln('SenseTSR is not installed!');
    halt(1);
  end;

  for n := 1 to 26 do
    if cVersion[n] <> char(mem[r.es:r.si]) then
      begin
        writeln('SenseTSR is not installed!');
        halt(1);
      end
    else
      inc(r.si);

  r.AH := nMultiplexID;
  r.AL := nGetTablePtr;
  intr($2F, r);

  if IsParameter('/1=') > 0 then
  begin
    GetSensitivity(IsParameter('/1=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX]   := nHS;
    mem[r.DS:r.DX+1] := nVS;
  end;

  if IsParameter('/2=') > 0 then
  begin
    GetSensitivity(IsParameter('/2=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+2] := nHS;
    mem[r.DS:r.DX+3] := nVS;
  end;

  if IsParameter('/3=') > 0 then
  begin
    GetSensitivity(IsParameter('/3=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+4] := nHS;
    mem[r.DS:r.DX+5] := nVS;
  end;

  if IsParameter('/4=') > 0 then
  begin
    GetSensitivity(IsParameter('/4=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+6] := nHS;
    mem[r.DS:r.DX+7] := nVS;
  end;

  if IsParameter('/5=') > 0 then
  begin
    GetSensitivity(IsParameter('/5=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+8] := nHS;
    mem[r.DS:r.DX+9] := nVS;
  end;

  if IsParameter('/6=') > 0 then
  begin
    GetSensitivity(IsParameter('/6=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+10] := nHS;
    mem[r.DS:r.DX+11] := nVS;
  end;

  if IsParameter('/7=') > 0 then
  begin
    GetSensitivity(IsParameter('/7=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+12] := nHS;
    mem[r.DS:r.DX+13] := nVS;
  end;

  if IsParameter('/8=') > 0 then
  begin
    GetSensitivity(IsParameter('/8=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+14] := nHS;
    mem[r.DS:r.DX+15] := nVS;
  end;

  if IsParameter('/9=') > 0 then
  begin
    GetSensitivity(IsParameter('/9=') + 3, nHS, nVS);

    { store horizontal and vertical speed }
    mem[r.DS:r.DX+16] := nHS;
    mem[r.DS:r.DX+17] := nVS;
  end;

  if IsParameter('/L=') > 0 then
  begin
    nLevel := GetLevel(IsParameter('/L=') + 3);

    if nLevel in [1..9] then
    begin
      { store sensitivity level }
      mem[r.DS:r.DX-1] := nLevel;

      nHS := mem[r.DS:r.DX + ((nLevel - 1) * 2)];
      nVS := mem[r.DS:r.DX + ((nLevel - 1) * 2)+1];

      SetMouseSensitivity(nHS, nVS);
    end;
  end;

  if IsParameter('/I=') > 0 then
  begin
     nIncKey := GetScanCode(IsParameter('/I=') + 3);
     SetIncreaseKey(nIncKey);
  end;

  if IsParameter('/D=') > 0 then
  begin
     nIncKey := GetScanCode(IsParameter('/D=') + 3);
     SetDecreaseKey(nIncKey);
  end;

  writeln( '1 = ', mem[r.DS:r.DX]   , ', ', mem[r.DS:r.DX+1]);
  writeln( '2 = ', mem[r.DS:r.DX+2] , ', ', mem[r.DS:r.DX+3]);
  writeln( '3 = ', mem[r.DS:r.DX+4] , ', ', mem[r.DS:r.DX+5]);
  writeln( '4 = ', mem[r.DS:r.DX+6] , ', ', mem[r.DS:r.DX+7]);
  writeln( '5 = ', mem[r.DS:r.DX+8] , ', ', mem[r.DS:r.DX+9]);
  writeln( '6 = ', mem[r.DS:r.DX+10], ', ', mem[r.DS:r.DX+11]);
  writeln( '7 = ', mem[r.DS:r.DX+12], ', ', mem[r.DS:r.DX+13]);
  writeln( '8 = ', mem[r.DS:r.DX+14], ', ', mem[r.DS:r.DX+15]);
  writeln( '9 = ', mem[r.DS:r.DX+16], ', ', mem[r.DS:r.DX+17]);
  writeln;

  writeln('Increase key: ', aKeys[mem[r.DS:r.DX+18]], ' (', mem[r.DS:r.DX+18], ').');
  writeln('Decrease key: ', aKeys[mem[r.DS:r.DX+19]], ' (', mem[r.DS:r.DX+19], ').');
  writeln;

  writeln('Current sensitivity level is ', mem[r.DS:r.DX-1], '.');
  writeln;
end.
