#include "polytex.h"
#include "pragmas.h"

#define NUMOPTIONS 8
#define NUMKEYS 19
char option[NUMOPTIONS], keys[NUMKEYS];

	//Screen control variables
long xdim, ydim, xpan, ypan, xres, zoom, brinum, drawmode;

	//Position,angle variables
point3d pos;
short fvel = 0, svel = 0, hvel = 0;  //Forward,Strafe,Height velocities
short a1, a2, a3, a1vel = 0, a2vel = 0, a3vel = 0;

	//Timing variables
long lockclock, synctics, numframes;
void (__interrupt __far *oldtimerhandler)();
void __interrupt __far timerhandler(void);

	//FPS display variables (averages last so many frames and shows in corner)
#define AVERAGEFRAMES 16
long frameval[AVERAGEFRAMES];

	//Editor variables (tab&enter)
char boardfilename[13];
long temppicnum = -1, tempshade = -1, dragpoint = -1;
short searchpoint, searchplane;
long searchitx, searchity, searchitz;

main(short argc, char **argv)
{
	strcpy(&boardfilename,"boards.map");
	if (argc >= 2) strcpy(&boardfilename,argv[1]);

	initgame();

	while (keystatus[1] == 0)
	{
		drawscreen();
		movethings();
	}

	cleanexit();
}

initgame()
{
	long fil;

	if ((fil = open("setup.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		read(fil,&option[0],NUMOPTIONS);
		read(fil,&keys[0],NUMKEYS);
		close(fil);
	}

	drawmode = 0;
	xdim = 320; ydim = 200; xres = xdim;
	if ((option[0] != 6) && (option[0] != 7))
		{ xpan = 0; ypan = 0; zoom = 65536; brinum = 4; }
	else
		{ xpan = 12288; ypan = 0; zoom = 80000; brinum = 12; }

	initengine(option[3]);
	loadpics("tiles000.art");

	setview(option[0],xdim,ydim,xpan,ypan,zoom,xres);
	setpalette(brinum);

	load3d("prmtvs01.3d");
	load3d("50pman.3d");
	loadboard(boardfilename,&pos.x,&pos.y,&pos.z,&a1,&a2,&a3);
	inittimer();
}

cleanexit()
{
	long i;

	uninittimer();
	setvmode(0x3);
	unloadpics();
	uninitengine();

	if (totalclock != 0)
	{
		i = scale(numframes,12000L,totalclock);
		printf("%ld.%1d%1d frames per second\n",i/100,(i/10)%10,i%10);
	}
	if ((option[0] == 6) || (option[0] == 7))
	{
		printf("Stereowidth: %ld\n",stereowidth);
		printf("Xpan: %ld\n",xpan);
		printf("Ypan: %ld\n",ypan);
		printf("Zoom: %ld\n",zoom);
	}
}

drawscreen()
{
	long i, j, k, ox, oy, oz, dax, day, daz, templong;
	char *ptr;

	drawview(pos.x,pos.y,pos.z,a1,a2,a3);

	obstatus = bstatus, getmousevalues(&mousx,&mousy,&bstatus);
	searchx += mousx;
	searchy += mousy;
	if (searchx < 4) searchx = 4;
	if (searchx >= xdim-4) searchx = xdim-4-1;
	if (searchy < 4) searchy = 4;
	if (searchy >= ydim-4) searchy = ydim-4-1;

	for(i=1;i<=4;i++)
	{
		drawpixel(frameplace+ylookup[searchy+i]+(searchx+0),whitecol);
		drawpixel(frameplace+ylookup[searchy-i]+(searchx+0),whitecol);
		drawpixel(frameplace+ylookup[searchy+0]+(searchx+i),whitecol);
		drawpixel(frameplace+ylookup[searchy+0]+(searchx-i),whitecol);
	}

	i = totalclock; j = (numframes&(AVERAGEFRAMES-1));
	if (i != frameval[j])
	{
		if (numframes > AVERAGEFRAMES)
		{
			sprintf(tempbuf,"%ld",(120*AVERAGEFRAMES)/(i-frameval[j]));
			printext256(0L,0L,31,-1,tempbuf,0);
		}
		frameval[j] = i;
	}

	if (keystatus[0x2e])  //Hold down 'C' to examine the 2D cache!
		for(i=0;i<MAXTILES;i++)
			if (waloff[i] != 0)
			{
				j = waloff[i]-FP_OFF(pic);
				ox = (j>>8); k = ox/xdim; oy = (j&255)+(k<<8); ox -= k*xdim;
				templong = min(tilesizy[i],ydim-oy);
				if (templong <= 0) continue;
				for(dax=0;dax<tilesizx[i];dax++)
				{
					ptr = (char *)(waloff[i]+(dax<<8));
					k = frameplace+ylookup[oy]+ox;
					for(day=templong;day>0;day--)
					{
						drawpixel(k,*ptr++);
						k += xdim;
					}
					ox++;
					if (ox >= xdim)
					{
						ox = 0; oy += 256;
						templong = min(tilesizy[i],ydim-oy);
						if (templong <= 0) break;
					}
				}
			}

	nextpage();
	numframes++;
}

movethings()
{
	long i, j, k, nextj, ox, oy, oz, templong, dist, nx1, ny1, nz1;
	long z0, z1, z2, dax, day, daz, xvect, yvect, zvect;
	char *ptr, shiftstate;

	if (keystatus[0x1d])    //Shoot a bullet
	{
		keystatus[0x1d] = 0;

		if ((j = insertsprite(getregion(pos.x,pos.y,pos.z),1)) >= 0)
		{
			spri[j].x = pos.x;
			spri[j].y = pos.y;
			spri[j].z = pos.z;

			xvect = 0; yvect = 0; zvect = 64;
			backrotate3d(&xvect,&yvect,&zvect);
			spri[j].xvel = xvect;
			spri[j].yvel = yvect;
			spri[j].zvel = zvect;

			spri[j].a1 = (rand()&2047);
			spri[j].a2 = (rand()&2047);
			spri[j].a3 = (rand()&2047);
			spri[j].a1vel = (rand()&31)-16;
			spri[j].a2vel = (rand()&31)-16;
			spri[j].a3vel = (rand()&31)-16;

			spri[j].objnum = 1;
			spri[j].stat = 0;
			spri[j].xscale = 64;
			spri[j].yscale = 64;
			spri[j].zscale = 64;

			spri[j].lotag = 0;
			spri[j].hitag = 0;
			spri[j].extra = 480;
		}
	}

	for(j=headspritestat[0];j>=0;j=nextspritestat[j])
	{
		spri[j].a1 += spri[j].a1vel;
		spri[j].a2 += spri[j].a2vel;
		spri[j].a3 += spri[j].a3vel;
	}

	for(j=headspritestat[1];j>=0;j=nextj)
	{
		nextj = nextspritestat[j];

		spri[j].x += (long)spri[j].xvel*synctics;
		spri[j].y += (long)spri[j].yvel*synctics;
		spri[j].z += (long)spri[j].zvel*synctics;

		k = spri[j].objnum;
		k = getregion(so[k].x+spri[j].x,so[k].y+spri[j].y,so[k].z+spri[j].z);
		if (k < 0) { deletesprite((short)j); continue; }
		changespritesect((short)j,getregion(so[k].x+spri[j].x,so[k].y+spri[j].y,so[k].z+spri[j].z));

		templong = -1;
		for(k=headspritesect[spri[j].sectnum];k>=0;k=nextspritesect[k])
			if (j != k)
				if (klabs(spri[j].x-spri[k].x) < 384)
					if (klabs(spri[j].y-spri[k].y) < 384)
						if (klabs(spri[j].z-spri[k].z) < 384)
						{
							templong = k;
							break;
						}
		if (templong >= 0)
		{
			spri[templong].xscale = min(spri[templong].xscale+16,255);
			spri[templong].yscale = min(spri[templong].yscale+16,255);
			spri[templong].zscale = min(spri[templong].zscale+16,255);
			deletesprite((short)j); continue;
		}

		spri[j].a1 += spri[j].a1vel*synctics;
		spri[j].a2 += spri[j].a2vel*synctics;
		spri[j].a3 += spri[j].a3vel*synctics;
		spri[j].extra -= synctics;
		if (spri[j].extra < 0) { deletesprite((short)j); continue; }
	}

	if (keystatus[0xc])  // - (left)
	{
		if (keystatus[0x2a]|keystatus[0x36])
		{
			if (zoom > 16384) zoom -= (zoom>>5);
		}
		else
		{
			if (xres > 32)
			{
				i = (xres>>5)+1; j = xres-i;
				if ((xres > 320) && (j <= 320)) xdim = 320, ydim = 200, j = xdim, keystatus[0xc] = 0;
				if ((xres > 640) && (j <= 640)) xdim = 640, ydim = 480, j = xdim, keystatus[0xc] = 0;
				if ((xres > 800) && (j <= 800)) xdim = 800, ydim = 600, j = xdim, keystatus[0xc] = 0;
				if ((xres > 1024) && (j <= 1024)) xdim = 1024, ydim = 768, j = xdim, keystatus[0xc] = 0;
				if ((xres > 1280) && (j <= 1280)) xdim = 1280, ydim = 1024, j = xdim, keystatus[0xc] = 0;
				xres = j; if (xres < 32) xres = 32;
			}
		}
		setview(option[0],xdim,ydim,xpan,ypan,zoom,xres);
	}
	if (keystatus[0xd])  // + (left)
	{
		if (keystatus[0x2a]|keystatus[0x36])
		{
			if (zoom < 262144) zoom += (zoom>>5);
		}
		else
		{
			if (xres < MAXXDIM)
			{
				if (xres == 320) xdim = 640, ydim = 480;
				if (xres == 640) xdim = 800, ydim = 600;
				if (xres == 800) xdim = 1024, ydim = 768;
				if (xres == 1024) xdim = 1280, ydim = 1024;
				if (xres == 1280) xdim = 1600, ydim = 1200;

				i = (xres>>5)+1; j = xres+i;
				if ((xres < 320) && (j >= 320)) xdim = 320, ydim = 200, j = xdim, keystatus[0xd] = 0;
				if ((xres < 640) && (j >= 640)) xdim = 640, ydim = 480, j = xdim, keystatus[0xd] = 0;
				if ((xres < 800) && (j >= 800)) xdim = 800, ydim = 600, j = xdim, keystatus[0xd] = 0;
				if ((xres < 1024) && (j >= 1024)) xdim = 1024, ydim = 768, j = xdim, keystatus[0xd] = 0;
				if ((xres < 1280) && (j >= 1280)) xdim = 1280, ydim = 1024, j = xdim, keystatus[0xd] = 0;
				xres = j; if (xres > MAXXDIM) xres = MAXXDIM;
			}
		}
		setview(option[0],xdim,ydim,xpan,ypan,zoom,xres);
	}
	if (keystatus[0x31])     // N (new board)
	{
		keystatus[0x31] = 0;
		newboard();
		pos.x = 0; pos.y = 0; pos.z = 0;
		a1 = 0; a2 = 0; a3 = 0;
	}
	if (keystatus[0x26])     // L (load)
	{
		keystatus[0x26] = 0;
		loadboard(boardfilename,&pos.x,&pos.y,&pos.z,&a1,&a2,&a3);
	}
	if (keystatus[0x1f]&(keystatus[0x38]|keystatus[0xb8]))     // Alt-S (save)
	{
		keystatus[0x1f] = 0;
		saveboard(boardfilename,&pos.x,&pos.y,&pos.z,&a1,&a2,&a3);
	}
	if (keystatus[0x2f])  // V
	{
		searchit();
		if (searchplane >= 0)
			plane[searchplane].texture = gettile(plane[searchplane].texture);
		keystatus[0x2f] = 0;
	}
	if (keystatus[0xf])   // Tab
	{
		keystatus[0xf] = 0;
		searchit();
		if (searchplane >= 0)
		{
			temppicnum = plane[searchplane].texture;
			tempshade = plane[searchplane].shade;
		}
	}
	if (keystatus[0x1c])  // L. Enter
	{
		keystatus[0x1c] = 0;
		if (temppicnum >= 0)
		{
			searchit();
			if (searchplane >= 0)
			{
				plane[searchplane].texture = temppicnum;
				plane[searchplane].shade = tempshade;
			}
		}
	}
	if (keystatus[0x4a])  // - (keypad)
	{
		keystatus[0x4a] = 0;
		if (keystatus[0x38]|keystatus[0xb8])  //ALT
		{
			brinum = max(brinum-1,0);
			setpalette(brinum);
		}
		else
		{
			searchit();
			if (searchplane >= 0) plane[searchplane].shade++;
		}
	}
	if (keystatus[0x4e])  // + (keypad)
	{
		keystatus[0x4e] = 0;
		if (keystatus[0x38]|keystatus[0xb8])  //ALT
		{
			brinum = min(brinum+1,15);
			setpalette(brinum);
		}
		else
		{
			searchit();
			if (searchplane >= 0) plane[searchplane].shade--;
		}
	}
	if (keystatus[0x51])  //Keyp. 3
	{
		searchit();
		if (searchplane >= 0)
		{
			nx1 = plane[searchplane].ux;
			ny1 = plane[searchplane].uy;
			nz1 = plane[searchplane].uz;
			reduce(nx1,ny1,nz1,32768);
			dist = ksqrt(nx1*nx1+ny1*ny1+nz1*nz1);

			z0 = lin[linoff[searchplane]];
			z1 = lin[linoff[searchplane]+1];
			z2 = lin[linoff[searchplane]+linnum[searchplane]-1];
			plane[searchplane].ox = p[z0].x;
			plane[searchplane].oy = p[z0].y;
			plane[searchplane].oz = p[z0].z;
			plane[searchplane].ux = p[z1].x-p[z0].x;
			plane[searchplane].uy = p[z1].y-p[z0].y;
			plane[searchplane].uz = p[z1].z-p[z0].z;
			plane[searchplane].vx = p[z2].x-p[z0].x;
			plane[searchplane].vy = p[z2].y-p[z0].y;
			plane[searchplane].vz = p[z2].z-p[z0].z;

			squareaspect(searchplane,(dist*63)>>6);
		}
	}
	if (keystatus[0x47])  //Keyp. 7
	{
		searchit();
		if (searchplane >= 0)
		{
			nx1 = plane[searchplane].ux - plane[searchplane].ox;
			ny1 = plane[searchplane].uy - plane[searchplane].oy;
			nz1 = plane[searchplane].uz - plane[searchplane].oz;
			reduce(nx1,ny1,nz1,32768);
			dist = ksqrt(nx1*nx1+ny1*ny1+nz1*nz1);

			z0 = lin[linoff[searchplane]];
			z1 = lin[linoff[searchplane]+1];
			z2 = lin[linoff[searchplane]+linnum[searchplane]-1];
			plane[searchplane].ox = p[z0].x;
			plane[searchplane].oy = p[z0].y;
			plane[searchplane].oz = p[z0].z;
			plane[searchplane].ux = p[z1].x-p[z0].x;
			plane[searchplane].uy = p[z1].y-p[z0].y;
			plane[searchplane].uz = p[z1].z-p[z0].z;
			plane[searchplane].vx = p[z2].x-p[z0].x;
			plane[searchplane].vy = p[z2].y-p[z0].y;
			plane[searchplane].vz = p[z2].z-p[z0].z;

			squareaspect(searchplane,(dist*65)>>6);
		}
	}
	if (keystatus[0x21])  //F
	{
		keystatus[0x21] = 0;
		searchit();
		if (searchplane >= 0)
		{
			nx1 = plane[searchplane].ux - plane[searchplane].ox;
			ny1 = plane[searchplane].uy - plane[searchplane].oy;
			nz1 = plane[searchplane].uz - plane[searchplane].oz;
			reduce(nx1,ny1,nz1,32768);
			dist = ksqrt(nx1*nx1+ny1*ny1+nz1*nz1);

			templong = lin[linoff[searchplane]];
			for(i=0;i<linnum[searchplane]-1;i++)
				lin[linoff[searchplane]+i] = lin[linoff[searchplane]+i+1];
			lin[linoff[searchplane]+linnum[searchplane]-1] = templong;

			z0 = lin[linoff[searchplane]];
			z1 = lin[linoff[searchplane]+1];
			z2 = lin[linoff[searchplane]+linnum[searchplane]-1];
			plane[searchplane].ox = p[z0].x;
			plane[searchplane].oy = p[z0].y;
			plane[searchplane].oz = p[z0].z;
			plane[searchplane].ux = p[z1].x-p[z0].x;
			plane[searchplane].uy = p[z1].y-p[z0].y;
			plane[searchplane].uz = p[z1].z-p[z0].z;
			plane[searchplane].vx = p[z2].x-p[z0].x;
			plane[searchplane].vy = p[z2].y-p[z0].y;
			plane[searchplane].vz = p[z2].z-p[z0].z;

			squareaspect(searchplane,dist);
		}
	}
	if (keystatus[0x13])  //R (Reverse mode! Inside/Outside)
	{
		keystatus[0x13] = 0;
		reversemode ^= 1;
	}
	if (keystatus[0x14])  //T
	{
		keystatus[0x14] = 0;
		searchit();
		if ((searchplane >= 0) && (linnum[searchplane] >= 3))
		{
			p[numpoints].x = searchitx;
			p[numpoints].y = searchity;
			p[numpoints].z = searchitz;
			numpoints++;

			for(i=linoff[searchplane]+linnum[searchplane]-1;i>=linoff[searchplane];i--)
			{
				linoff[numplanes] = numlines;
				linnum[numplanes] = 3;
				lin2[numlines+0] = numlines+1;
				lin2[numlines+1] = numlines+2;
				lin2[numlines+2] = numlines+0;
				lin[numlines++] = lin[i];
				lin[numlines++] = lin[lin2[i]];
				lin[numlines++] = numpoints-1;

				memcpy(&plane[numplanes],&plane[searchplane],sizeof(plane[0]));
				numplanes++;
			}

			resizelinnum((long)searchplane,3L);          //Set new size
			numplanes--; numlines -= linnum[numplanes];  //Delete last plane
			j = linoff[searchplane]-linoff[numplanes];   //Copy back
			for(i=linnum[numplanes]-1;i>=0;i--)
			{
				lin[i+linoff[searchplane]] = lin[i+linoff[numplanes]];
				lin2[i+linoff[searchplane]] = lin2[i+linoff[numplanes]]+j;
			}

			makebsp();
		}
	}

	if (keystatus[0x19])          //P
	{
		keystatus[0x19] = 0;
		searchit();
		if (searchplane >= 0) plane[searchplane].flags ^= 1;
	}
	if (keystatus[0x32])          //M
	{
		keystatus[0x32] = 0;
		searchit();
		if (searchplane >= 0) plane[searchplane].flags ^= 2;
	}
	if (keystatus[0x30])          //B
	{
		keystatus[0x30] = 0;
		searchit();
		if (searchplane >= 0) plane[searchplane].flags ^= 4;
	}

	if (bstatus&1)
	{
		if ((obstatus&1) == 0)
		{
			searchit();
			dragpoint = searchpoint;
		}

		if (dragpoint)
		{
			if (bstatus&6)
			{
				if (((a3+256)&1536) == 0) p[dragpoint].z -= (mousy<<3);
				if (((a3+256)&1536) == 512) p[dragpoint].x -= (mousy<<3);
				if (((a3+256)&1536) == 1024) p[dragpoint].z += (mousy<<3);
				if (((a3+256)&1536) == 1536) p[dragpoint].x += (mousy<<3);
			}
			else
				p[dragpoint].y += (mousy<<3);

			if (((a3+256)&1536) == 0) p[dragpoint].x += (mousx<<3);
			if (((a3+256)&1536) == 512) p[dragpoint].z -= (mousx<<3);
			if (((a3+256)&1536) == 1024) p[dragpoint].x -= (mousx<<3);
			if (((a3+256)&1536) == 1536) p[dragpoint].z += (mousx<<3);

			for(i=0;i<numplanes;i++)
				for(j=0;j<linnum[i];j++)
					if (lin[linoff[i]+j] == dragpoint)
					{
						z0 = lin[linoff[i]+0];
						z1 = lin[linoff[i]+1];
						z2 = lin[linoff[i]+linnum[i]-1];
						plane[i].ox = p[z0].x;
						plane[i].oy = p[z0].y;
						plane[i].oz = p[z0].z;
						plane[i].ux = p[z1].x-p[z0].x;
						plane[i].uy = p[z1].y-p[z0].y;
						plane[i].uz = p[z1].z-p[z0].z;
						plane[i].vx = p[z2].x-p[z0].x;
						plane[i].vy = p[z2].y-p[z0].y;
						plane[i].vz = p[z2].z-p[z0].z;
						calcnormal(i);
						squareaspect((short)i,1024L);
					}
		}
	}
	else if (obstatus&1)
	{
		p[dragpoint].x = ((p[dragpoint].x+128)&0xffffff00);
		p[dragpoint].y = ((p[dragpoint].y+128)&0xffffff00);
		p[dragpoint].z = ((p[dragpoint].z+128)&0xffffff00);

		for(i=0;i<numplanes;i++)
			for(j=0;j<linnum[i];j++)
				if (lin[linoff[i]+j] == dragpoint)
				{
					z0 = lin[linoff[i]+0];
					z1 = lin[linoff[i]+1];
					z2 = lin[linoff[i]+linnum[i]-1];
					plane[i].ox = p[z0].x;
					plane[i].oy = p[z0].y;
					plane[i].oz = p[z0].z;
					plane[i].ux = p[z1].x-p[z0].x;
					plane[i].uy = p[z1].y-p[z0].y;
					plane[i].uz = p[z1].z-p[z0].z;
					plane[i].vx = p[z2].x-p[z0].x;
					plane[i].vy = p[z2].y-p[z0].y;
					plane[i].vz = p[z2].z-p[z0].z;
					calcnormal(i);
					squareaspect((short)i,1024L);
				}

		dragpoint = -1;
		makebsp();
	}

	if (keystatus[0x58])   //F12
	{
		screencapture();
		keystatus[0x58] = 0;
	}

	if (keystatus[0x9c])
	{
		keystatus[0x9c] = 0;
		if (keystatus[0x2a]|keystatus[0x36])
		{
			if (spritedrawmode) spritedrawmode--; else spritedrawmode = 2;
		}
		else
		{
			if (keystatus[0x1d]|keystatus[0x9d])
				drawmode = 1;
			else
			{
				drawmode++;
				if (drawmode == 1) drawmode = 2;
				if (drawmode == 4) drawmode = 0;
			}
			setdrawmode(drawmode);
		}
	}

	shiftstate = (keystatus[0x2a]|keystatus[0x36]);

	xvect = (svel<<(shiftstate+1));
	yvect = (hvel<<shiftstate);
	zvect = (fvel<<(shiftstate+1));
	if ((xvect|yvect|zvect) != 0)
	{
		xvect *= (synctics<<8);
		yvect *= (synctics<<8);
		zvect *= (synctics<<8);
		backrotate3d(&xvect,&yvect,&zvect);
		clipmove(&pos.x,&pos.y,&pos.z,xvect>>11,yvect>>11,zvect>>11);
	}

	if (keystatus[0x52])    //0 on keypad (return to normal angle)
	{
		if (keystatus[0x1d]|keystatus[0x9d])
		{
			a2 = ((a2+1536)&2047);
			if (a2 < 1024) { a2 -= (synctics<<1); if (a2 < 0) a2 = 0; }
			else           { a2 += (synctics<<1); if (a2 >= 2048) a2 = 0; }
			a2 = ((a2+512)&2047);
		}
		else
		{
			if (a2 < 1024) { a2 -= (synctics<<1); if (a2 < 0) a2 = 0; }
			else           { a2 += (synctics<<1); if (a2 >= 2048) a2 = 0; }
		}
		if (a1 < 1024) { a1 -= (synctics<<1); if (a1 < 0) a1 = 0; }
		else           { a1 += (synctics<<1); if (a1 >= 2048) a1 = 0; }
	}

	a1 = ((a1+((a1vel*synctics)>>(4-shiftstate))+2048)&2047);
	a2 = ((a2+((a2vel*synctics)>>(4-shiftstate))+2048)&2047);
	a3 = ((a3+((a3vel*synctics)>>(4-shiftstate))+2048)&2047);

		//Auto-Tilting
	if (a3vel == 0)
	{
		if (a1 < 1024)
		{
			a1 -= (synctics<<1);
			if (a1 < 0) a1 = 0;
		}
		else
		{
			a1 += (synctics<<1);
			if (a1 >= 2048) a1 = 0;
		}
	}
	else
	{
		a1 = (((((((a1+1024)&2047)*7) + (1024-a3vel))>>3)+1024)&2047);
	}

	synctics = totalclock-lockclock;
	lockclock += synctics;
}

privatekeys()
{
	long i, j, k, nextj, ox, oy, oz, templong, dist, nx1, ny1, nz1;
	long z0, z1, z2, dax, day, daz, xvect, yvect, zvect;
	char *ptr, shiftstate;

	if (keystatus[0xc])  // - (left)
	{
		if (keystatus[0x2a]|keystatus[0x36])
		{
			if (zoom > 16384) zoom -= (zoom>>5);
		}
		else
		{
			if (xres > 32)
			{
				i = (xres>>5)+1; j = xres-i;
				if ((xres > 320) && (j <= 320)) xdim = 320, ydim = 200, j = xdim, keystatus[0xc] = 0;
				if ((xres > 640) && (j <= 640)) xdim = 640, ydim = 480, j = xdim, keystatus[0xc] = 0;
				if ((xres > 800) && (j <= 800)) xdim = 800, ydim = 600, j = xdim, keystatus[0xc] = 0;
				if ((xres > 1024) && (j <= 1024)) xdim = 1024, ydim = 768, j = xdim, keystatus[0xc] = 0;
				if ((xres > 1280) && (j <= 1280)) xdim = 1280, ydim = 1024, j = xdim, keystatus[0xc] = 0;
				xres = j; if (xres < 32) xres = 32;
			}
		}
		setview(option[0],xdim,ydim,xpan,ypan,zoom,xres);
	}
	if (keystatus[0xd])  // + (left)
	{
		if (keystatus[0x2a]|keystatus[0x36])
		{
			if (zoom < 262144) zoom += (zoom>>5);
		}
		else
		{
			if (xres < MAXXDIM)
			{
				if (xres == 320) xdim = 640, ydim = 480;
				if (xres == 640) xdim = 800, ydim = 600;
				if (xres == 800) xdim = 1024, ydim = 768;
				if (xres == 1024) xdim = 1280, ydim = 1024;
				if (xres == 1280) xdim = 1600, ydim = 1200;

				i = (xres>>5)+1; j = xres+i;
				if ((xres < 320) && (j >= 320)) xdim = 320, ydim = 200, j = xdim, keystatus[0xd] = 0;
				if ((xres < 640) && (j >= 640)) xdim = 640, ydim = 480, j = xdim, keystatus[0xd] = 0;
				if ((xres < 800) && (j >= 800)) xdim = 800, ydim = 600, j = xdim, keystatus[0xd] = 0;
				if ((xres < 1024) && (j >= 1024)) xdim = 1024, ydim = 768, j = xdim, keystatus[0xd] = 0;
				if ((xres < 1280) && (j >= 1280)) xdim = 1280, ydim = 1024, j = xdim, keystatus[0xd] = 0;
				xres = j; if (xres > MAXXDIM) xres = MAXXDIM;
			}
		}
		setview(option[0],xdim,ydim,xpan,ypan,zoom,xres);
	}
	if (keystatus[0x4a])  // - (keypad)
	{
		keystatus[0x4a] = 0;
		if (keystatus[0x38]|keystatus[0xb8])  //ALT
		{
			brinum = min(brinum-1,0);
			setpalette(brinum);
		}
		else
		{
			searchit();
			if (searchplane >= 0) plane[searchplane].shade++;
		}
	}
	if (keystatus[0x4e])  // + (keypad)
	{
		keystatus[0x4e] = 0;
		if (keystatus[0x38]|keystatus[0xb8])  //ALT
		{
			brinum = max(brinum+1,15);
			setpalette(brinum);
		}
		else
		{
			searchit();
			if (searchplane >= 0) plane[searchplane].shade--;
		}
	}
}

searchit()
{
	long i, xv, yv, zv;

	searchitx = pos.x;
	searchity = pos.y;
	searchitz = pos.z;

	xv = ((searchx-(xdim>>1))<<8);
	yv = ((searchy-(ydim>>1))<<8);
	zv = (xdim<<7);
	backrotate3d(&xv,&yv,&zv);

	searchplane = hitscan(&searchitx,&searchity,&searchitz,xv,yv,zv);
	searchpoint = -1;
	if (searchplane >= 0)
		for(i=linoff[searchplane]+linnum[searchplane]-1;i>=linoff[searchplane];i--)
			if (klabs(p[lin[i]].x-searchitx) < 256)
				if (klabs(p[lin[i]].y-searchity) < 256)
					if (klabs(p[lin[i]].z-searchitz) < 256)
						searchpoint = lin[i];
}

inittimer()
{
	outp(0x43,54); outp(0x40,9942&255); outp(0x40,9942>>8);  //120 times/sec
	oldtimerhandler = _dos_getvect(0x8);
	_disable(); _dos_setvect(0x8, timerhandler); _enable();
	totalclock = 0L;
	lockclock = 0L;
	numframes = 0;
	synctics = 0;
}

uninittimer()
{
	outp(0x43,54); outp(0x40,255); outp(0x40,255);           //18.2 times/sec
	_disable(); _dos_setvect(0x8, oldtimerhandler); _enable();
}

void __interrupt __far timerhandler()
{
	totalclock++;
	keytimerstuff();

	_chain_intr(oldtimerhandler);
	//koutp(0x20,0x20);
}

keytimerstuff()
{
		//Acceleration
	if (keystatus[keys[0]]) fvel = min(fvel+8,127);
	if (keystatus[keys[1]]) fvel = max(fvel-8,-128);
	if (keystatus[0x2c]) hvel = min(hvel+8,127);
	if (keystatus[0x1e]) hvel = max(hvel-8,-128);
	if (keystatus[keys[5]])
	{
		if (keystatus[keys[3]]) svel = min(svel+8,127);
		if (keystatus[keys[2]]) svel = max(svel-8,-128);
	}
	else
	{
		if (keystatus[keys[3]]) a3vel = min(a3vel+16,127);
		if (keystatus[keys[2]]) a3vel = max(a3vel-16,-128);
	}
	if (keystatus[0x33]) a1vel = min(a1vel+16,127);
	if (keystatus[0x34]) a1vel = max(a1vel-16,-128);
	if (keystatus[keys[11]]) a2vel = min(a2vel+16,127);
	if (keystatus[keys[10]]) a2vel = max(a2vel-16,-128);

		//Friction
	if (fvel < 0) fvel = min(fvel+2,0);
	if (fvel > 0) fvel = max(fvel-2,0);
	if (svel < 0) svel = min(svel+2,0);
	if (svel > 0) svel = max(svel-2,0);
	if (hvel < 0) hvel = min(hvel+2,0);
	if (hvel > 0) hvel = max(hvel-2,0);
	if (a1vel < 0) a1vel = min(a1vel+12,0);
	if (a1vel > 0) a1vel = max(a1vel-12,0);
	if (a2vel < 0) a2vel = min(a2vel+12,0);
	if (a2vel > 0) a2vel = max(a2vel-12,0);
	if (a3vel < 0) a3vel = min(a3vel+12,0);
	if (a3vel > 0) a3vel = max(a3vel-12,0);
}
