//I support 320*200, 640*480, 800*600, 1024*768, 1280*1024, 1600*1200
#define ENGINE
#define MAXBUNCHES 256
#define MAXDIAG MAXXDIM+MAXXDIM+MAXYDIM
#define MAXCLIPLANES 256
#define MAXCLIPOINTS 512
#define MAXSORTNUM 64

#define MAXSECTORS 1024
#define MAXWALLS 8192
#define MAXSPRITES 4096

#define savebyte(fil,tempbuf,bufplc,dat)        \
{                                               \
	tempbuf[bufplc++] = dat;                     \
	if (bufplc == 4096)                          \
	{                                            \
		bufplc = 0;                               \
		if (write(fil,&tempbuf[0],4096) < 4096)   \
		{                                         \
			close(fil);                            \
			return(-1);                            \
		}                                         \
	}                                            \
}

#include "polytex.h"
#include "pragmas.h"

static long xdim = -1, ydim = -1, curbrightness = -1;
static long xdimup15, ydimup15, xpan = -1, ypan = -1;
static long xdimscale, ydimscale, xreszoom, xres = -1, zoom = -1;
static long xdimscale1, xdimscale2, ydimscale1, ydimscale2;
static char curview = -1, vidoption = -1;

static char intbstatus, mouseirq, mousetemp;
static char mousebyte[3], mouselookup[4] = {0,2,1,3}, mousebytecnt;
static long intmousx, intmousy, mouseport = -1;
static void (__interrupt __far *oldmousehandler)();
static void __interrupt __far mousehandler(void);

static point3d clip[MAXCLIPOINTS];
static short cliplinoff[MAXCLIPLANES], cliplinnum[MAXCLIPLANES];
static short cliplanum[MAXCLIPLANES];
static long clipoints, cliplanes;

static short split[MAXPOINTS], splitcnt;
static char got[MAXPOINTS];

static char britable[16][64];
static char textfont[1024], smalltextfont[1024];
static long sqrtable[2048];

static long objdist[MAXSPRIS], objsort[MAXSPRIS];

static long baktotalclock;

static long globx, globy, globz;
static short globa1, globa2, globa3;

static long globm;
static long globdax, globday;
static long getd, getdxinc, getdyinc;
static long gett;
static long getu, getuxinc, getuyinc, globuadd;
static long getv, getvxinc, getvyinc, globvadd;

static char drawmode;
void drawfasttextureplane(long npoints);
void drawslowtextureplane(long npoints);
void drawsolidplane(long npoints);
void drawwireplane(long npoints);
void (*globdrawplanefunction)(long npoints);

static short h1[MAXXDIM<<1], n1[MAXXDIM<<5], p1[MAXXDIM<<5];
static short h2[MAXXDIM<<1], n2[MAXXDIM<<5], p2[MAXXDIM<<5];

static short doti[MAXYDIM*16], *dotp[MAXYDIM];
static lastx[MAXDIAG];

static long slist[MAXSORTNUM], snum;
static long cy[MAXSORTNUM*MAXXDIM], cyy[MAXSORTNUM];
static long hplc[MAXXDIM+1], point2[MAXPOINTS], point22[MAXPOINTS];
static short bunchstart[MAXBUNCHES], bunchend[MAXBUNCHES], numbunches;

static long mapversion;
static char artfilename[20];
static long artsize = 0, artversion, picsloaded = 0;
static long artfil, artfilnum, artfilplc, numtilefiles;
static char paletteloaded = 0, translucloaded = 0;
static char tilefilenum[MAXTILES];
static long tilefileoffs[MAXTILES];
static long localtilestart[MAXTILEFILES], localtileend[MAXTILEFILES];

static char vesapageshift, curpag, tsengdriver;

long asm1, asm2, asm3, asm4, asm64[2];
long haddtable[MAXXDIM+1];

static char globstat;
static long globplane, globshade, globtext;
static long g, g2;
static planetype *globpla, *grecpla;
static point3d *grecpoi;

static long rc[9], rc2[9];
//static long cornx[4], corny[4], cornz[4];

volatile char readch, oldreadch, extended, keytemp;
void (__interrupt __far *oldkeyhandler)();
void __interrupt __far keyhandler(void);

static short capturecount = 0;
static char pcxheader[128] =
{
	0xa,0x5,0x1,0x8,0x0,0x0,0x0,0x0,0x3f,0x1,0xc7,0x0,
	0x40,0x1,0xc8,0x0,0x0,0x0,0x0,0x8,0x8,0x8,0x10,0x10,
	0x10,0x18,0x18,0x18,0x20,0x20,0x20,0x28,0x28,0x28,0x30,0x30,
	0x30,0x38,0x38,0x38,0x40,0x40,0x40,0x48,0x48,0x48,0x50,0x50,
	0x50,0x58,0x58,0x58,0x60,0x60,0x60,0x68,0x68,0x68,0x70,0x70,
	0x70,0x78,0x78,0x78,0x0,0x1,0x40,0x1,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
};

typedef struct
{
	short wallptr, wallnum;
	long ceilingz, floorz;
	short ceilingstat, floorstat;
	short ceilingpicnum, ceilingheinum;
	signed char ceilingshade;
	char ceilingpal, ceilingxpanning, ceilingypanning;
	short floorpicnum, floorheinum;
	signed char floorshade;
	char floorpal, floorxpanning, floorypanning;
	char visibility, filler;
	short lotag, hitag, extra;
} sectortype;

typedef struct
{
	long x, y;
	short point2, nextwall, nextsector, cstat;
	short picnum, overpicnum;
	signed char shade;
	char pal, xrepeat, yrepeat, xpanning, ypanning;
	short lotag, hitag, extra;
} walltype;

typedef struct
{
	long x, y, z;
	short cstat, picnum;
	signed char shade;
	char pal, clipdist, filler;
	unsigned char xrepeat, yrepeat;
	signed char xoffset, yoffset;
	short sectnum, statnum;
	short ang, owner, xvel, yvel, zvel;
	short lotag, hitag, extra;
} spritetype;

static sectortype sector[MAXSECTORS];
static walltype wall[MAXWALLS];
static spritetype sprite[MAXSPRITES];

extern long dline(long,long,long,long,long,long);
#pragma aux dline parm [eax][ebx][ecx][edx][esi][edi];
extern long vline(long,long,long,long,long,long);
#pragma aux vline parm [eax][ebx][ecx][edx][esi][edi];
extern long hline(long,long,long,long,long,long);
#pragma aux hline parm [eax][ebx][ecx][edx][esi][edi];

extern long mdline(long,long,long,long,long,long);
#pragma aux mdline parm [eax][ebx][ecx][edx][esi][edi];
extern long mvline(long,long,long,long,long,long);
#pragma aux mvline parm [eax][ebx][ecx][edx][esi][edi];
extern long mhline(long,long,long,long,long,long);
#pragma aux mhline parm [eax][ebx][ecx][edx][esi][edi];

extern long setupvline(long,long,long);
#pragma aux setupvline parm [eax][ebx][ecx];
extern long setuphline(long,long,long);
#pragma aux setuphline parm [eax][ebx][ecx];
extern long setupdline(long,long,long);
#pragma aux setupdline parm [eax][ebx][ecx];

extern long msetupvline(long,long,long);
#pragma aux msetupvline parm [eax][ebx][ecx];
extern long msetuphline(long,long,long);
#pragma aux msetuphline parm [eax][ebx][ecx];
extern long msetupdline(long,long,long);
#pragma aux msetupdline parm [eax][ebx][ecx];

extern long setxdim(long);
#pragma aux setxdim parm [eax];

#pragma aux fpustartdivscale =\
	"mov edx, eax",\
	"sar edx, 31",\
	"shld edx, eax, cl",\
	"sal eax, cl",\
	"mov dword ptr asm64[0], eax",\
	"mov dword ptr asm64[4], edx",\
	"mov asm2, ebx",\
	"fild qword ptr asm64[0]",\
	"fidiv asm2",\
	parm [eax][ebx][ecx]\
	modify [edx]\

#pragma aux fpustartdivide =\
	"mov asm1, eax",\
	"mov asm2, ebx",\
	"fild asm1",\
	"fidiv asm2",\
	parm [eax][ebx]\

#pragma aux fpugetdivide =\
	"fistp dword ptr asm1",\
	"mov eax, dword ptr asm1",\

#pragma aux vesasetmode =\
	"mov ax, 0x4f02",\
	"int 0x10",\
	"and eax, 0x0000ffff",\
	parm [ebx]\
	modify [eax ebx]\

#pragma aux vesasetpage =\
	"mov cl, vesapageshift",\
	"shl dx, cl",\
	"cmp dl, curpag",\
	"je skipsetpage",\
	"mov curpag, dl",\
	"mov ax, 0x4f05",\
	"xor bx, bx",\
	"int 0x10",\
	"skipsetpage:",\
	parm [edx]\
	modify [eax ebx ecx]\

// 11,12 is 2,1-10
// 13,14 is 4,2-10
// 15,16 is 6,3-10
#pragma aux ksqrtasm =\
	"or eax, eax",\
	"jz endksqrtasm",\
	"jns skipnegate",\
	"neg eax",\
	"skipnegate: bsr ecx, eax",\
	"cmp ecx, 11",\
	"jge over2048",\
	"mov eax, dword ptr sqrtable[eax*4]",\
	"shr eax, 10",\
	"jmp endksqrtasm",\
	"over2048:",\
	"sub cl, 9",\
	"and cl, 0xfe",\
	"shr eax, cl",\
	"mov eax, dword ptr sqrtable[eax*4]",\
	"shr cl, 1",\
	"shl eax, cl",\
	"shr eax, 10",\
	"endksqrtasm:",\
	parm [eax]\
	modify [eax ebx ecx edx]\

#pragma aux setupandgetmouseirq =\
	"xor eax, eax",\
	"int 0x33",\
	"jz skipit",\
	"mov eax, 36",\
	"int 0x33",\
	"mov mouseirq, cl",\
	"mov eax, -1",\
	"skipit:",\
	modify [eax ecx]\

void __interrupt __far keyhandler()
{
	oldreadch = readch; readch = kinp(0x60);
	keytemp = kinp(0x61); koutp(0x61,keytemp|128); koutp(0x61,keytemp&127);
	if ((readch|1) == 0xe1)
		extended = 128;
	else
	{
		if (oldreadch != readch)
			keystatus[(readch&127)+extended] = ((readch>>7)^1);
		extended = 0;
	}
	koutp(0x20,0x20);
	if (keystatus[0x46])
	{
		outp(0x43,54); outp(0x40,255); outp(0x40,255);    //18.2 times/sec
		unloadpics();
		uninitengine();
		setvmode(0x3);
		exit(0);
	}
}

initengine(char mouoption)
{
	long i;

	loadtables();

		//Must initialize mouse stuff before timer!  But why?
	if (mouoption == 1) initmouse();

	spritedrawmode = 2;
	snumpoints = 0; snumplanes = 0;  snumobjects = 0; snumgroups = 0;
	stereopage = 0; stereowidth = 4608;
	reversemode = 0;
	curpag = 0; tsengdriver = 0;
	setdrawmode(0);

	if ((screen = (char *)malloc((MAXXDIM+4)*MAXYDIM)) == NULL)
		if ((screen = (char *)malloc((640+4)*480)) == NULL)
			if ((screen = (char *)malloc((320+4)*200)) == NULL)
			{
				printf("Not enough memory for screen buffer\n");
				uninitengine();
				exit(0);
			}

	for(i=0;i<MAXDIAG;i++) lastx[i] = 0x7fffffff;

	oldkeyhandler = _dos_getvect(0x9);
	_disable(); _dos_setvect(0x9, keyhandler); _enable();
}

uninitengine()
{
	_dos_setvect(0x9, oldkeyhandler);
	free(pic);
	uninitmouse();
}

loadtables()
{
	long i, fil;

	for(i=0;i<2048;i++) sqrtable[i] = calcksqrt(i<<20);
	if ((fil = open("tables.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		read(fil,sintable,2048*2);
		lseek(fil,4096+640*2,SEEK_SET);
		read(fil,textfont,1024);
		read(fil,smalltextfont,1024);
		read(fil,britable,1024);
		close(fil);
	}
}

loadtile (short tnum)
{
	char *ptr;
	long i, j, k, l, xsiz, ysiz;

	if ((tilesizx[tnum] <= 0) || (tilesizy[tnum] <= 0)) return;
	if (tilesizy[tnum] > 256) return;

	i = tilefilenum[tnum];
	if (i != artfilnum)
	{
		if (artfil != -1) close(artfil);
		artfilnum = i;
		artfilplc = 0L;

		artfilename[7] = (i%10)+48;
		artfilename[6] = ((i/10)%10)+48;
		artfilename[5] = ((i/100)%10)+48;
		artfil = open(artfilename,O_BINARY|O_RDONLY,S_IREAD);
	}

	xsiz = tilesizx[tnum];
	ysiz = tilesizy[tnum]; if (ysiz > 256) ysiz = 256;

	if (waloff[tnum] == 0) cachebox(&waloff[tnum],xsiz,ysiz);

	if (artfilplc != tilefileoffs[tnum])
	{
		artfilplc = tilefileoffs[tnum];
		lseek(artfil,artfilplc,SEEK_SET);
	}
	ptr = (char *)waloff[tnum];

	l = 16;
	if (ysiz <= 128)
	{
		l = 32;
		if (ysiz <= 64)
		{
			l = 64;
			if (ysiz <= 32) l = 128;
		}
	}
	for(i=0;i<xsiz;i+=l)
	{
		j = min(xsiz-i,l);
		read(artfil,tempbuf,j*ysiz);

		k = FP_OFF(tempbuf);
		while (j > 0)
		{
			copybufbyte(k,ptr,ysiz);
			j--; k += ysiz; ptr += 256;
		}
	}
	artfilplc += xsiz*ysiz;
}

loadpics(char *filename)
{
	long i, j, k, fil, offscount, siz, templongbuf[4];

	strcpy(artfilename,filename);

	for(i=0;i<MAXTILES;i++)
		{ waloff[i] = 0; tilesizx[i] = 0L; tilesizy[i] = 0L; picanm[i] = 0L; }

	artsize = 0L;

	numtilefiles = 0;
	do
	{
		k = numtilefiles;

		artfilename[7] = (k%10)+48;
		artfilename[6] = ((k/10)%10)+48;
		artfilename[5] = ((k/100)%10)+48;
		if ((fil = open(artfilename,O_BINARY|O_RDONLY,S_IREAD)) != -1)
		{
			read(fil,templongbuf,16);
			artversion = templongbuf[0]; if (artversion != 1) return(-1);
			numtiles = templongbuf[1];
			localtilestart[k] = templongbuf[2];
			localtileend[k] = templongbuf[3];
			read(fil,tempshort,(localtileend[k]-localtilestart[k]+1)<<1);
			for(i=localtileend[k]-localtilestart[k];i>=0;i--)
				tilesizx[i+localtilestart[k]] = tempshort[i];
			read(fil,tempshort,(localtileend[k]-localtilestart[k]+1)<<1);
			for(i=localtileend[k]-localtilestart[k];i>=0;i--)
				tilesizy[i+localtilestart[k]] = tempshort[i];
			read(fil,&picanm[localtilestart[k]],(localtileend[k]-localtilestart[k]+1)<<2);

			offscount = 4+4+4+4+((localtileend[k]-localtilestart[k]+1)<<3);
			for(i=localtilestart[k];i<=localtileend[k];i++)
			{
				tilefilenum[i] = k;
				tilefileoffs[i] = offscount;
				j = tilesizx[i]*tilesizy[i];
				offscount += j; artsize += j;
			}
			close(fil);

			numtilefiles++;
		}
	}
	while (k != numtilefiles);

		//150% of art size
	i = ((artsize+(artsize>>1))&0xffffff00);
	while ((pic = (char *)malloc(i)) == NULL) i -= 65536;
	initcache(FP_OFF(pic),i);

	for(i=0;i<MAXTILES;i++)
	{
		j = 15;
		while ((j > 0) && ((1<<j) > tilesizx[i])) j--;
		picsiz[i] = ((char)j);
		j = 15;
		while ((j > 0) && ((1<<j) > tilesizy[i])) j--;
		picsiz[i] += ((char)(j<<4));
	}

	picsloaded = 1;

	artfil = -1;
	artfilnum = -1;
	artfilplc = 0L;

	return(0);
}

unloadpics()
{
	if (artfil != -1) close(artfil);
	free(pic);
	picsloaded = 0;
}

newboard()
{
	long i, j, k, z0, z1, z2;

	initspritelists();

	numpoints = 8;
	p[0].x = -512; p[0].y = -512; p[0].z = -512;
	p[1].x = 512;  p[1].y = -512; p[1].z = -512;
	p[2].x = -512; p[2].y = 512;  p[2].z = -512;
	p[3].x = 512;  p[3].y = 512;  p[3].z = -512;
	p[4].x = -512; p[4].y = -512; p[4].z = 512;
	p[5].x = 512;  p[5].y = -512; p[5].z = 512;
	p[6].x = -512; p[6].y = 512;  p[6].z = 512;
	p[7].x = 512;  p[7].y = 512;  p[7].z = 512;

	numplanes = 6;
	linnum[0] = 4; lin[0] = 4; lin[1] = 5; lin[2] = 7; lin[3] = 6;
	linnum[1] = 4; lin[4] = 5; lin[5] = 1; lin[6] = 3; lin[7] = 7;
	linnum[2] = 4; lin[8] = 1; lin[9] = 0; lin[10] = 2; lin[11] = 3;
	linnum[3] = 4; lin[12] = 0; lin[13] = 4; lin[14] = 6; lin[15] = 2;
	linnum[4] = 4; lin[16] = 0; lin[17] = 1; lin[18] = 5; lin[19] = 4;
	linnum[5] = 4; lin[20] = 6; lin[21] = 7; lin[22] = 3; lin[23] = 2;

	numlines = 24;

	j = 0;
	for(i=0;i<numplanes;i++)
	{
		linoff[i] = j;
		calcnormal(i);
		j += linnum[i];
	}

	for(i=0;i<numplanes;i++)
	{
		plane[i].shade = -4;
		plane[i].texture = i+24;
		plane[i].flags = 0;

		z0 = lin[linoff[i]];
		z1 = lin[linoff[i]+1];
		z2 = lin[linoff[i]+linnum[i]-1];
		plane[i].ox = p[z0].x;
		plane[i].oy = p[z0].y;
		plane[i].oz = p[z0].z;
		plane[i].ux = p[z1].x-p[z0].x;
		plane[i].uy = p[z1].y-p[z0].y;
		plane[i].uz = p[z1].z-p[z0].z;
		plane[i].vx = p[z2].x-p[z0].x;
		plane[i].vy = p[z2].y-p[z0].y;
		plane[i].vz = p[z2].z-p[z0].z;

		squareaspect((short)i,1024L);
	}

	for(i=0;i<numplanes;i++)
	{
		lin2[linoff[i]+linnum[i]-1] = linoff[i];
		for(k=linoff[i];k<linoff[i]+linnum[i]-1;k++) lin2[k] = k+1;
	}

	makebsp();
}

loadboard(char *filename, long *posx, long *posy, long *posz,
			 short *a1, short *a2, short *a3)
{
	long fil, i, j, k, l, z0, z1, z2, startwall, endwall, tempx, tempy, tempz;
	long cz, fz, ncz, nfz;
	short cursectnum, numsectors, numwalls, numsprites, datempshort;

	char cstat;
	long daz, daz2, tilenum, xoff, yoff, xspan, yspan, xrepeat, yrepeat;
	long cosang, sinang, dax, day, x1, y1, x2, y2, x3, y3, x4, y4;
	sectortype *sec;
	walltype *wal, *wal2;
	spritetype *spr;

	if (strchr(filename,'.') == 0) strcat(filename,".map");
	if ((fil = open(filename,O_BINARY|O_RDONLY,S_IREAD)) == -1)
	{
		setvmode(0x3);
		printf("File not found\n");
		exit(0);
	}

	initspritelists();

	read(fil,&mapversion,4);
	if (mapversion == 0x00020000)
	{
		read(fil,posx,4);
		read(fil,posy,4);
		read(fil,posz,4);
		read(fil,a1,2);
		read(fil,a2,2);
		read(fil,a3,2);
		read(fil,&numplanes,2);
		read(fil,&numlines,2);
		read(fil,&numpoints,2);
		read(fil,p,sizeof(p[0])*numpoints);
		read(fil,&linnum[0],numplanes<<1);
		read(fil,&lin[0],numlines<<1);
		read(fil,&lin2[0],numlines<<1);
		read(fil,plane,sizeof(plane[0])*numplanes);
		read(fil,&head,2);

		j = 0;
		for(i=0;i<numplanes;i++)
		{
			linoff[i] = j;
			j += linnum[i];
		}
	}
	else if (mapversion == 7L)                 //Convert Build map
	{
		read(fil,posz,4);
		read(fil,posx,4);
		read(fil,posy,4);
		*posx = ((*posx)<<1);
		*posy = ((*posy)>>3);
		*posz = ((*posz)<<1);
		*a1 = 0;
		*a2 = 0;
		read(fil,a3,2);
		read(fil,&cursectnum,2);

		read(fil,&numsectors,2);
		read(fil,&sector[0],sizeof(sectortype)*numsectors);
		read(fil,&numwalls,2);
		read(fil,&wall[0],sizeof(walltype)*numwalls);
		read(fil,&numsprites,2);
		read(fil,&sprite[0],sizeof(spritetype)*numsprites);

		numplanes = 0; numlines = 0; numpoints = 0;
		for(i=0;i<numsectors;i++)
		{
			cz = (sector[i].ceilingz>>4);
			fz = (sector[i].floorz>>4);
			for(j=sector[i].wallnum,wal=&wall[sector[i].wallptr];j>0;j--,wal++)
			{
				if (wal->nextsector == -1)
				{
					linoff[numplanes] = numlines;
					linnum[numplanes] = 0;

					lin2[numlines+0] = numlines+1;
					lin2[numlines+1] = numlines+2;
					lin2[numlines+2] = numlines+3;
					lin2[numlines+3] = numlines+0;
					wal2 = &wall[wal->point2];
					lin[numlines++] = newpoint(wal->y<<1,cz<<1,wal->x<<1);
					lin[numlines++] = newpoint(wal2->y<<1,cz<<1,wal2->x<<1);
					lin[numlines++] = newpoint(wal2->y<<1,fz<<1,wal2->x<<1);
					lin[numlines++] = newpoint(wal->y<<1,fz<<1,wal->x<<1);

					linnum[numplanes] = numlines-linoff[numplanes];
					plane[numplanes].texture = wal->picnum;
					plane[numplanes].shade = wal->shade;
					plane[numplanes].flags = ((wal->cstat&1)<<2);

					z0 = lin[linoff[numplanes]];
					z1 = lin[linoff[numplanes]+1];
					z2 = lin[linoff[numplanes]+3];
					plane[numplanes].ox = p[z0].x;
					plane[numplanes].oy = p[z0].y;
					plane[numplanes].oz = p[z0].z;
					plane[numplanes].ux = p[z1].x-p[z0].x;
					plane[numplanes].uy = p[z1].y-p[z0].y;
					plane[numplanes].uz = p[z1].z-p[z0].z;
					plane[numplanes].vx = p[z2].x-p[z0].x;
					plane[numplanes].vy = p[z2].y-p[z0].y;
					plane[numplanes].vz = p[z2].z-p[z0].z;
					calcnormal((long)numplanes);

					if ((wal->xrepeat > 0) && (wal->yrepeat > 0))
					{
						plane[numplanes].ux = divscale(plane[numplanes].ux,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);
						plane[numplanes].vy = (256<<(picsiz[plane[numplanes].texture]>>4)) / wal->yrepeat;
						plane[numplanes].uz = divscale(plane[numplanes].uz,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);

						if (tilesizx[plane[numplanes].texture] > 0)
						{
							tempx = -scale(plane[numplanes].ux,wal->xpanning,tilesizx[plane[numplanes].texture]);
							tempz = -scale(plane[numplanes].uz,wal->xpanning,tilesizx[plane[numplanes].texture]);
						}
						tempy = -mulscale8(plane[numplanes].vy,wal->ypanning);
						if ((wal->cstat&4) > 0) tempy += ((fz-cz)<<1);
						plane[numplanes].ox += tempx;
						plane[numplanes].oy += tempy;
						plane[numplanes].oz += tempz;
					}

					drawbspbox(numplanes,whitecol);
					numplanes++;
				}
				else
				{
					ncz = (sector[wal->nextsector].ceilingz>>4);
					nfz = (sector[wal->nextsector].floorz>>4);
					if (ncz > cz)
					{
						linoff[numplanes] = numlines;
						linnum[numplanes] = 0;

						lin2[numlines+0] = numlines+1;
						lin2[numlines+1] = numlines+2;
						lin2[numlines+2] = numlines+3;
						lin2[numlines+3] = numlines+0;
						wal2 = &wall[wal->point2];
						lin[numlines++] = newpoint(wal->y<<1,cz<<1,wal->x<<1);
						lin[numlines++] = newpoint(wal2->y<<1,cz<<1,wal2->x<<1);
						lin[numlines++] = newpoint(wal2->y<<1,ncz<<1,wal2->x<<1);
						lin[numlines++] = newpoint(wal->y<<1,ncz<<1,wal->x<<1);

						linnum[numplanes] = numlines-linoff[numplanes];
						plane[numplanes].texture = wal->picnum;
						plane[numplanes].shade = wal->shade;
						plane[numplanes].flags = ((wal->cstat&1)<<2);

						z0 = lin[linoff[numplanes]];
						z1 = lin[linoff[numplanes]+1];
						z2 = lin[linoff[numplanes]+3];
						plane[numplanes].ox = p[z0].x;
						plane[numplanes].oy = p[z0].y;
						plane[numplanes].oz = p[z0].z;
						plane[numplanes].ux = p[z1].x-p[z0].x;
						plane[numplanes].uy = p[z1].y-p[z0].y;
						plane[numplanes].uz = p[z1].z-p[z0].z;
						plane[numplanes].vx = p[z2].x-p[z0].x;
						plane[numplanes].vy = p[z2].y-p[z0].y;
						plane[numplanes].vz = p[z2].z-p[z0].z;
						calcnormal((long)numplanes);

						if ((wal->xrepeat > 0) && (wal->yrepeat > 0))
						{
							plane[numplanes].ux = divscale(plane[numplanes].ux,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);
							plane[numplanes].vy = (256<<(picsiz[plane[numplanes].texture]>>4)) / wal->yrepeat;
							plane[numplanes].uz = divscale(plane[numplanes].uz,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);

							if (tilesizx[plane[numplanes].texture] > 0)
							{
								tempx = -scale(plane[numplanes].ux,wal->xpanning,tilesizx[plane[numplanes].texture]);
								tempz = -scale(plane[numplanes].uz,wal->xpanning,tilesizx[plane[numplanes].texture]);
							}
							tempy = -mulscale8(plane[numplanes].vy,wal->ypanning);
							if ((wal->cstat&4) == 0) tempy += ((ncz-cz)<<1);
							plane[numplanes].ox += tempx;
							plane[numplanes].oy += tempy;
							plane[numplanes].oz += tempz;
						}

						drawbspbox(numplanes,whitecol);
						numplanes++;
					}
					if (nfz < fz)
					{
						linoff[numplanes] = numlines;
						linnum[numplanes] = 0;

						lin2[numlines+0] = numlines+1;
						lin2[numlines+1] = numlines+2;
						lin2[numlines+2] = numlines+3;
						lin2[numlines+3] = numlines+0;
						wal2 = &wall[wal->point2];
						lin[numlines++] = newpoint(wal->y<<1,nfz<<1,wal->x<<1);
						lin[numlines++] = newpoint(wal2->y<<1,nfz<<1,wal2->x<<1);
						lin[numlines++] = newpoint(wal2->y<<1,fz<<1,wal2->x<<1);
						lin[numlines++] = newpoint(wal->y<<1,fz<<1,wal->x<<1);

						linnum[numplanes] = numlines-linoff[numplanes];
						plane[numplanes].texture = wal->picnum;
						plane[numplanes].shade = wal->shade;
						plane[numplanes].flags = ((wal->cstat&1)<<2);

						z0 = lin[linoff[numplanes]];
						z1 = lin[linoff[numplanes]+1];
						z2 = lin[linoff[numplanes]+3];
						plane[numplanes].ox = p[z0].x;
						plane[numplanes].oy = p[z0].y;
						plane[numplanes].oz = p[z0].z;
						plane[numplanes].ux = p[z1].x-p[z0].x;
						plane[numplanes].uy = p[z1].y-p[z0].y;
						plane[numplanes].uz = p[z1].z-p[z0].z;
						plane[numplanes].vx = p[z2].x-p[z0].x;
						plane[numplanes].vy = p[z2].y-p[z0].y;
						plane[numplanes].vz = p[z2].z-p[z0].z;
						calcnormal((long)numplanes);

						if ((wal->xrepeat > 0) && (wal->yrepeat > 0))
						{
							plane[numplanes].ux = divscale(plane[numplanes].ux,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);
							plane[numplanes].vy = (256<<(picsiz[plane[numplanes].texture]>>4)) / wal->yrepeat;
							plane[numplanes].uz = divscale(plane[numplanes].uz,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);

							if (tilesizx[plane[numplanes].texture] > 0)
							{
								tempx = -scale(plane[numplanes].ux,wal->xpanning,tilesizx[plane[numplanes].texture]);
								tempz = -scale(plane[numplanes].uz,wal->xpanning,tilesizx[plane[numplanes].texture]);
							}
							tempy = -mulscale8(plane[numplanes].vy,wal->ypanning);
							if (wal->cstat&4) tempy += ((cz-nfz)<<1);
							plane[numplanes].ox += tempx;
							plane[numplanes].oy += tempy;
							plane[numplanes].oz += tempz;
						}

						drawbspbox(numplanes,whitecol);
						numplanes++;
					}
					if ((wal->cstat&16) > 0)
					{
						linoff[numplanes] = numlines;
						linnum[numplanes] = 0;

						z1 = max(cz,ncz);
						z2 = min(fz,nfz);

						lin2[numlines+0] = numlines+1;
						lin2[numlines+1] = numlines+2;
						lin2[numlines+2] = numlines+3;
						lin2[numlines+3] = numlines+0;
						wal2 = &wall[wal->point2];
						lin[numlines++] = newpoint(wal->y<<1,z1<<1,wal->x<<1);
						lin[numlines++] = newpoint(wal2->y<<1,z1<<1,wal2->x<<1);
						lin[numlines++] = newpoint(wal2->y<<1,z2<<1,wal2->x<<1);
						lin[numlines++] = newpoint(wal->y<<1,z2<<1,wal->x<<1);

						linnum[numplanes] = numlines-linoff[numplanes];
						plane[numplanes].texture = wal->overpicnum;
						plane[numplanes].shade = wal->shade;
						plane[numplanes].flags = 2 + ((wal->cstat&1^1)<<2);  //Reverse bit 2 for masked walls

						z0 = lin[linoff[numplanes]];
						z1 = lin[linoff[numplanes]+1];
						z2 = lin[linoff[numplanes]+3];
						plane[numplanes].ox = p[z0].x;
						plane[numplanes].oy = p[z0].y;
						plane[numplanes].oz = p[z0].z;
						plane[numplanes].ux = p[z1].x-p[z0].x;
						plane[numplanes].uy = p[z1].y-p[z0].y;
						plane[numplanes].uz = p[z1].z-p[z0].z;
						plane[numplanes].vx = p[z2].x-p[z0].x;
						plane[numplanes].vy = p[z2].y-p[z0].y;
						plane[numplanes].vz = p[z2].z-p[z0].z;
						calcnormal((long)numplanes);

						if ((wal->xrepeat > 0) && (wal->yrepeat > 0))
						{
							plane[numplanes].ux = divscale(plane[numplanes].ux,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);
							plane[numplanes].vy = (256<<(picsiz[plane[numplanes].texture]>>4)) / wal->yrepeat;
							plane[numplanes].uz = divscale(plane[numplanes].uz,wal->xrepeat<<3,picsiz[plane[numplanes].texture]&15);

							if (tilesizx[plane[numplanes].texture] > 0)
							{
								tempx = -scale(plane[numplanes].ux,wal->xpanning,tilesizx[plane[numplanes].texture]);
								tempz = -scale(plane[numplanes].uz,wal->xpanning,tilesizx[plane[numplanes].texture]);
							}
							tempy = -mulscale8(plane[numplanes].vy,wal->ypanning);
							plane[numplanes].ox += tempx;
							plane[numplanes].oy += tempy;
							plane[numplanes].oz += tempz;
						}

						drawbspbox(numplanes,whitecol);
						numplanes++;
					}
				}
			}
		}

		for(i=0;i<numsectors;i++)
		{
			startwall = sector[i].wallptr;
			endwall = startwall + sector[i].wallnum - 1;

				//Ceiling
			linoff[numplanes] = numlines;
			linnum[numplanes] = 0;

			for(j=startwall;j<=endwall;j++)
			{
				lin2[numlines] = wall[j].point2-j+numlines;
				lin[numlines] = newpoint(wall[j].y<<1,sector[i].ceilingz>>3,wall[j].x<<1);
				numlines++;
			}
			linnum[numplanes] = numlines-linoff[numplanes];

				//Reverse order for ceilings
			k = linoff[numplanes];
			for(j=linoff[numplanes];j<numlines;j++)
				if (lin2[j] < j)
				{
					for(l=((j-k+1)>>1)-1;l>=0;l--)
					{
						datempshort = lin[k+l];
						lin[k+l] = lin[j-l];
						lin[j-l] = datempshort;
					}
					k = j+1;
				}

			plane[numplanes].texture = sector[i].ceilingpicnum;
			plane[numplanes].shade = sector[i].ceilingshade;
			plane[numplanes].flags = (sector[i].ceilingstat&1);
			j = lin[linoff[numplanes]];
			plane[numplanes].ox = (p[j].x&0xfffff000);
			plane[numplanes].oy = p[j].y;
			plane[numplanes].oz = (p[j].z&0xfffff000);
			plane[numplanes].ux = (1<<(5+(picsiz[plane[numplanes].texture]&15)));
			plane[numplanes].uy = 0;
			plane[numplanes].uz = 0;
			plane[numplanes].vx = 0;
			plane[numplanes].vy = 0;
			plane[numplanes].vz = (1<<(5+(picsiz[plane[numplanes].texture]>>4)));
			plane[numplanes].normal.x = 0;
			plane[numplanes].normal.y = -65536;
			plane[numplanes].normal.z = 0;
			drawbspbox(numplanes,whitecol);
			numplanes++;

				//Floor
			linoff[numplanes] = numlines;
			linnum[numplanes] = 0;

			k = -1;
			for(j=startwall;j<=endwall;j++)
			{
				lin2[numlines] = wall[j].point2-j+numlines;
				lin[numlines] = newpoint(wall[j].y<<1,sector[i].floorz>>3,wall[j].x<<1);
				numlines++;
			}

			linnum[numplanes] = numlines-linoff[numplanes];
			plane[numplanes].texture = sector[i].floorpicnum;
			plane[numplanes].shade = sector[i].floorshade;
			plane[numplanes].flags = (sector[i].floorstat&1);
			j = lin[linoff[numplanes]];
			plane[numplanes].ox = (p[j].x&0xfffff000);
			plane[numplanes].oy = p[j].y;
			plane[numplanes].oz = (p[j].z&0xfffff000);
			plane[numplanes].ux = 0;
			plane[numplanes].uy = 0;
			plane[numplanes].uz = 0+(1<<(5+(picsiz[plane[numplanes].texture]&15)));
			plane[numplanes].vx = 0+(1<<(5+(picsiz[plane[numplanes].texture]>>4)));
			plane[numplanes].vy = 0;
			plane[numplanes].vz = 0;
			plane[numplanes].normal.x = 0;
			plane[numplanes].normal.y = 65536;
			plane[numplanes].normal.z = 0;
			drawbspbox(numplanes,whitecol);
			numplanes++;
		}

		for(i=0;i<numsprites;i++)
		{
			spr = &sprite[i];
			cstat = spr->cstat;

			tempx = (spr->y<<1);
			tempy = (spr->z>>3);
			tempz = (spr->x<<1);

			if ((spr->cstat&48) == 48) continue;   //BAD CASE!!!!

			if ((spr->cstat&48) == 0)
			{
				if ((~spr->cstat)&128)
					tempy -= ((tilesizy[plane[i].texture]*spr->yrepeat)>>2);

				k = spr->picnum;
				if ((k == 110) || (k == 113) || (k == 114) || (k == 115) || (k == 120))
				{
					j = insertsprite(0,0);
					spri[j].x = tempx; spri[j].y = tempy; spri[j].z = tempz;
					spri[j].a1 = 0; spri[j].a2 = 0; spri[j].a3 = 0;
					spri[j].xvel = 0; spri[j].yvel = 0; spri[j].zvel = 0;
					spri[j].a1vel = 0;
					spri[j].a2vel = 0;
					spri[j].a3vel = (krand()&63)-32;
					spri[j].objnum = 0;
					spri[j].stat = 0;
					spri[j].xscale = 64; spri[j].yscale = 64; spri[j].zscale = 64;
					spri[j].lotag = 0;
					spri[j].hitag = 0;
					spri[j].extra = 0;
				}
				else
				{
					j = insertsprite(0,0);
					spri[j].x = tempx; spri[j].y = tempy; spri[j].z = tempz;
					spri[j].a1 = 0; spri[j].a2 = 0; spri[j].a3 = 0;
					spri[j].xvel = 0; spri[j].yvel = 0; spri[j].zvel = 0;
					spri[j].a1vel = (krand()&31)-16;
					spri[j].a2vel = (krand()&31)-16;
					spri[j].a3vel = (krand()&31)-16;
					spri[j].objnum = 2;
					spri[j].stat = 0;
					spri[j].xscale = 64; spri[j].yscale = 64; spri[j].zscale = 64;
					spri[j].lotag = 0;
					spri[j].hitag = 0;
					spri[j].extra = 0;
				}
				continue;
			}

			linoff[numplanes] = numlines;
			linnum[numplanes] = 4;
			switch (spr->cstat&48)
			{
				case 16:
					daz = spr->z;
					daz2 = spr->z-((tilesizy[spr->picnum]*spr->yrepeat)<<2);

						//These lines get the 2 points of the rotated sprite
						 //Given: (x1, y1) starts out as the center point
					tilenum = spr->picnum;
					xoff = (long)((signed char)((picanm[tilenum]>>8)&255));
					if ((cstat&4) > 0) xoff = -xoff;
					k = spr->ang; l = spr->xrepeat;
					dax = sintable[k&2047]*l; day = sintable[(k+1536)&2047]*l;
					l = tilesizx[tilenum]; k = (l>>1)+xoff;
					x1 = spr->x-mulscale16(dax,k); x2 = x1+mulscale16(dax,l);
					y1 = spr->y-mulscale16(day,k); y2 = y1+mulscale16(day,l);

					lin2[numlines+0] = numlines+1;
					lin2[numlines+1] = numlines+2;
					lin2[numlines+2] = numlines+3;
					lin2[numlines+3] = numlines+0;
					lin[numlines++] = newpoint(y1<<1,daz2>>3,x1<<1);
					lin[numlines++] = newpoint(y2<<1,daz2>>3,x2<<1);
					lin[numlines++] = newpoint(y2<<1,daz>>3,x2<<1);
					lin[numlines++] = newpoint(y1<<1,daz>>3,x1<<1);
					break;
				case 32:
					tilenum = spr->picnum;
					xoff = (long)((signed char)((picanm[tilenum]>>8)&255));
					yoff = (long)((signed char)((picanm[tilenum]>>16)&255));
					if ((cstat&4) > 0) xoff = -xoff;
					if ((cstat&8) > 0) yoff = -yoff;

					k = spr->ang;
					cosang = sintable[(k+512)&2047]; sinang = sintable[k];
					xspan = tilesizx[tilenum]; xrepeat = spr->xrepeat;
					yspan = tilesizy[tilenum]; yrepeat = spr->yrepeat;

					dax = ((xspan>>1)+xoff)*xrepeat; day = ((yspan>>1)+yoff)*yrepeat;
					x1 = spr->x+dmulscale16(sinang,dax,cosang,day);
					y1 = spr->y+dmulscale16(sinang,day,-cosang,dax);
					l = xspan*xrepeat;
					x2 = x1-mulscale16(sinang,l);
					y2 = y1+mulscale16(cosang,l);
					l = yspan*yrepeat;
					k = -mulscale16(cosang,l); x3 = x2+k; x4 = x1+k;
					k = -mulscale16(sinang,l); y3 = y2+k; y4 = y1+k;

					lin2[numlines+0] = numlines+1;
					lin2[numlines+1] = numlines+2;
					lin2[numlines+2] = numlines+3;
					lin2[numlines+3] = numlines+0;
					if ((cstat&8) == 0)
					{
						lin[numlines++] = newpoint(y1<<1,tempy,x1<<1);
						lin[numlines++] = newpoint(y2<<1,tempy,x2<<1);
						lin[numlines++] = newpoint(y3<<1,tempy,x3<<1);
						lin[numlines++] = newpoint(y4<<1,tempy,x4<<1);
					}
					else
					{
						lin[numlines++] = newpoint(y2<<1,tempy,x2<<1);
						lin[numlines++] = newpoint(y1<<1,tempy,x1<<1);
						lin[numlines++] = newpoint(y4<<1,tempy,x4<<1);
						lin[numlines++] = newpoint(y3<<1,tempy,x3<<1);
					}
					break;
			}
			plane[numplanes].texture = spr->picnum;
			plane[numplanes].shade = spr->shade;
			plane[numplanes].flags = ((spr->cstat&1^1)<<2)+2;
			plane[numplanes].ox = p[lin[numlines-4]].x;
			plane[numplanes].oy = p[lin[numlines-4]].y;
			plane[numplanes].oz = p[lin[numlines-4]].z;
			plane[numplanes].ux = p[lin[numlines-3]].x-p[lin[numlines-4]].x;
			plane[numplanes].uy = p[lin[numlines-3]].y-p[lin[numlines-4]].y;
			plane[numplanes].uz = p[lin[numlines-3]].z-p[lin[numlines-4]].z;
			plane[numplanes].vx = p[lin[numlines-1]].x-p[lin[numlines-4]].x;
			plane[numplanes].vy = p[lin[numlines-1]].y-p[lin[numlines-4]].y;
			plane[numplanes].vz = p[lin[numlines-1]].z-p[lin[numlines-4]].z;
			calcnormal((long)numplanes);
			drawbspbox(numplanes,whitecol);
			numplanes++;

			if (cstat&64) continue;   //1-sided

			//Sprite - double sided - must do back side also
			linoff[numplanes] = numlines;
			linnum[numplanes] = 4;
			lin2[numlines+0] = numlines+1;
			lin2[numlines+1] = numlines+2;
			lin2[numlines+2] = numlines+3;
			lin2[numlines+3] = numlines+0;
			lin[numlines++] = lin[linoff[numplanes-1]+1];
			lin[numlines++] = lin[linoff[numplanes-1]+0];
			lin[numlines++] = lin[linoff[numplanes-1]+3];
			lin[numlines++] = lin[linoff[numplanes-1]+2];
			plane[numplanes].texture = spr->picnum;
			plane[numplanes].shade = spr->shade;
			plane[numplanes].flags = ((spr->cstat&1^1)<<2)+2;
			plane[numplanes].ox = p[lin[numlines-4]].x;
			plane[numplanes].oy = p[lin[numlines-4]].y;
			plane[numplanes].oz = p[lin[numlines-4]].z;
			plane[numplanes].ux = p[lin[numlines-3]].x-p[lin[numlines-4]].x;
			plane[numplanes].uy = p[lin[numlines-3]].y-p[lin[numlines-4]].y;
			plane[numplanes].uz = p[lin[numlines-3]].z-p[lin[numlines-4]].z;
			plane[numplanes].vx = p[lin[numlines-1]].x-p[lin[numlines-4]].x;
			plane[numplanes].vy = p[lin[numlines-1]].y-p[lin[numlines-4]].y;
			plane[numplanes].vz = p[lin[numlines-1]].z-p[lin[numlines-4]].z;
			calcnormal((long)numplanes);
			drawbspbox(numplanes,whitecol);
			numplanes++;
		}

		for(i=0;i<numplanes;i++)
		{
			j = plane[i].texture;
			if ((tilesizx[j] <= 0) || (tilesizy[j] <= 0))
				plane[i].texture = 0;
		}
		makebsp();
	}
	else
	{
		setvmode(0x3);
		printf("Wrong map version\n");
		exit(0);
	}

	close(fil);

	for(k=groupoff[1];k<groupoff[2];k++)
	{
		j = insertsprite(0,0);
		spri[j].x = *posx; spri[j].y = *posy; spri[j].z = *posz;
		spri[j].a1 = 0; spri[j].a2 = 0; spri[j].a3 = 0;
		spri[j].xvel = 0; spri[j].yvel = 0; spri[j].zvel = 0;
		spri[j].a1vel = 0;
		spri[j].a2vel = 0;
		spri[j].a3vel = (krand()&63)-32;
		spri[j].objnum = k;
		spri[j].stat = 0;
		spri[j].xscale = 64; spri[j].yscale = 64; spri[j].zscale = 64;
		spri[j].lotag = 0;
		spri[j].hitag = 0;
		spri[j].extra = 0;
	}

	for(i=MAXSPRIS-1;i>=0;i--)
		if (spri[i].statnum < MAXSTATUS)
		{
			j = spri[i].objnum;
			changespritesect((short)i,getregion(so[j].x+spri[i].x,so[j].y+spri[i].y,so[j].z+spri[i].z));
		}
}

newpoint(long x, long y, long z)
{
	long i;

	for(i=numpoints-1;i>=0;i--)
		if ((p[i].x == x) && (p[i].y == y) && (p[i].z == z)) return(i);

	p[numpoints].x = x;
	p[numpoints].y = y;
	p[numpoints].z = z;
	numpoints++;
	return(numpoints-1);
}

saveboard(char *filename, long *posx, long *posy, long *posz,
			 short *a1, short *a2, short *a3)
{
	long fil, i;

	if (strchr(filename,'.') == 0) strcat(filename,".map");
	if ((fil = open(filename,O_BINARY|O_TRUNC|O_CREAT|O_WRONLY,S_IWRITE)) == -1)
		return(-1);

	mapversion = 0x00020000;
	write(fil,&mapversion,4);
	write(fil,posx,4);
	write(fil,posy,4);
	write(fil,posz,4);
	write(fil,a1,2);
	write(fil,a2,2);
	write(fil,a3,2);
	write(fil,&numplanes,2);
	write(fil,&numlines,2);
	write(fil,&numpoints,2);
	write(fil,p,sizeof(p[0])*numpoints);
	write(fil,&linnum[0],numplanes<<1);
	write(fil,&lin[0],numlines<<1);
	write(fil,&lin2[0],numlines<<1);
	write(fil,plane,sizeof(plane[0])*numplanes);
	write(fil,&head,2);
	close(fil);

	return(0);
}

drawview(long dax, long day, long daz, short da1, short da2, short da3)
{
	point3d vect;

	globx = dax; globy = day; globz = daz;
	globa1 = da1; globa2 = da2; globa3 = da3;
	baktotalclock = totalclock;

	setuprotate3d(globa1,globa2,globa3,rc);
	copybuf(rc,rc2,9);

	if ((vidoption == 6) || (vidoption == 7))
	{
		if ((keystatus[0x2a]|keystatus[0x36]) > 0)
		{
			if (keystatus[0x1a] > 0) xpan -= 256;   //Shift [
			if (keystatus[0x1b] > 0) xpan += 256;   //Shift ]
		}
		else
		{
			if (keystatus[0x1a] > 0) stereowidth += 512;   //[
			if (keystatus[0x1b] > 0) stereowidth -= 512;   //]
		}

		vect.x = stereowidth; vect.y = 0; vect.z = 0;
		backrotate3d(&vect.x,&vect.y,&vect.z);
		vect.x >>= 8; vect.y >>= 8; vect.z >>= 8;

		globx -= vect.x; globy -= vect.y; globz -= vect.z;

		frameplace = FP_OFF(screen)+(xdim<<1);
		setview(vidoption,xdim,ydim,xpan,ypan,zoom,xres); drawframe();

		globx += (vect.x<<1); globy += (vect.y<<1); globz += (vect.z<<1);
		xpan = -xpan;

		frameplace += xdim*ydim;
		setview(vidoption,xdim,ydim,xpan,ypan,zoom,xres); drawframe();

		globx -= vect.x; globy -= vect.y; globz -= vect.z;
		xpan = -xpan;
	}
	else
	{
		drawframe();
	}
}

drawframe()
{
	long i;

	if (drawmode == 3)       //if (drawmode == 3) drawgrid();
		clearbuf(frameplace,(xdim*ydim)>>2,0L);
	else if (checkinside(globx,globy,globz) == 0)
		clearbuf(frameplace,(xdim*ydim)>>2,0L);

	for(i=numpoints;i>=0;i--)
	{
		ri[i].x = ((p[i].x-globx)<<12);
		ri[i].y = ((p[i].y-globy)<<12);
		ri[i].z = ((p[i].z-globz)<<12);
		rotate3d(&ri[i].x,&ri[i].y,&ri[i].z);
	}

	recurseit(head);
}

squareaspect(short i, long boxsiz)
{
	long nx1, ny1, nz1, nx2, ny2, nz2, nx3, ny3, nz3, nx4, ny4, nz4;
	long dist, templong;
	planetype *pla;

	pla = &plane[i];

	nx1 = pla->ux; ny1 = pla->uy; nz1 = pla->uz;
	reduce(nx1,ny1,nz1,32768);
	dist = ksqrtasm(nx1*nx1+ny1*ny1+nz1*nz1);
	if (dist >= 16)
	{
		templong = divscale16(boxsiz,dist);
		nx1 = mulscale16(nx1,templong);
		ny1 = mulscale16(ny1,templong);
		nz1 = mulscale16(nz1,templong);
	}

	nx2 = pla->vx; ny2 = pla->vy; nz2 = pla->vz;
	reduce(nx2,ny2,nz2,32768);
	dist = ksqrtasm(nx2*nx2+ny2*ny2+nz2*nz2);
	if (dist >= 16)
	{
		templong = divscale16(boxsiz,dist);
		nx2 = mulscale16(nx2,templong);
		ny2 = mulscale16(ny2,templong);
		nz2 = mulscale16(nz2,templong);
	}

		//<b?v[1]-b?v[0]> x <b?v[2]-b?v[0]>
		//normalx = y0z1-y1z0, normaly = x1z0-x0z1, normalz = x0y1-x1y0
	nx3 = ny1*nz2 - ny2*nz1;
	ny3 = nx2*nz1 - nx1*nz2;
	nz3 = nx1*ny2 - nx2*ny1;
	reduce(nx3,ny3,nz3,32768);
	dist = ksqrtasm(nx3*nx3+ny3*ny3+nz3*nz3);
	if (dist >= 16)
	{
		templong = divscale16(boxsiz,dist);
		nx3 = mulscale16(nx3,templong);
		ny3 = mulscale16(ny3,templong);
		nz3 = mulscale16(nz3,templong);
	}

		//<b?v[1]-b?v[0]> x <n?>
		//normalx = y0z1-y1z0, normaly = x1z0-x0z1, normalz = x0y1-x1y0
	nx4 = ny1*nz3 - ny3*nz1;
	ny4 = nx3*nz1 - nx1*nz3;
	nz4 = nx1*ny3 - nx3*ny1;
	reduce(nx4,ny4,nz4,32768);
	dist = ksqrtasm(nx4*nx4+ny4*ny4+nz4*nz4);
	if (dist >= 16)
	{
		templong = divscale16(boxsiz,dist);
		nx4 = mulscale16(nx4,templong);
		ny4 = mulscale16(ny4,templong);
		nz4 = mulscale16(nz4,templong);
	}

	pla->ux = nx1; pla->uy = ny1; pla->uz = nz1;
	pla->vx = -nx4; pla->vy = -ny4; pla->vz = -nz4;
}

calcnormal(long dap)
{
	long i, i0, i1, i2, x, y, z, x1, y1, z1, x2, y2, z2, nx, ny, nz;

	nx = 0; ny = 0; nz = 0;
	for(i=linoff[dap]+linnum[dap]-1;i>=linoff[dap];i--)
	{
		i0 = i; i1 = lin2[i]; i2 = lin2[lin2[i]];
		i0 = lin[i0]; i1 = lin[i1]; i2 = lin[i2];
		x = p[i1].x; x1 = p[i2].x-x; x2 = p[i0].x-x;
		y = p[i1].y; y1 = p[i2].y-y; y2 = p[i0].y-y;
		z = p[i1].z; z1 = p[i2].z-z; z2 = p[i0].z-z;
		nx += y1*z2 - y2*z1;
		ny += x2*z1 - x1*z2;
		nz += x1*y2 - x2*y1;
	}
	reduce(nx,ny,nz,65536);
	plane[dap].normal.x = nx;
	plane[dap].normal.y = ny;
	plane[dap].normal.z = nz;
}

setview (char davidoption, long daxdim, long daydim, long daxpan,
			long daypan, long dazoom, long daxres)
{
	long i, j, fil;

	if (paletteloaded == 0)
	{
		if ((fil = open("palette.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
		{
			read(fil,palette,768);
			read(fil,&numpalookups,2);
			read(fil,palookup,numpalookups<<8);

			if (translucloaded == 0)
				if ((transluc = (char *)malloc(65536L)) != 0)
					translucloaded = 1;

			read(fil,transluc,65536);

			blackcol = 0; j = 0x7fffffff;
			for(i=0;i<256;i++)
				if (palette[i*3]+palette[i*3+1]+palette[i*3+2] < j)
				{
					j = palette[i*3]+palette[i*3+1]+palette[i*3+2];
					blackcol = i;
				}

			whitecol = 0; j = 0x80000000;
			for(i=0;i<256;i++)
				if (palette[i*3]+palette[i*3+1]+palette[i*3+2] > j)
				{
					j = palette[i*3]+palette[i*3+1]+palette[i*3+2];
					whitecol = i;
				}

			close(fil);
		}
		paletteloaded = 1;
	}

	if (davidoption < 2) davidoption = 2;
	if ((vidoption != davidoption) || (xdim != daxdim) || (ydim != daydim))
	{
		if ((daxdim == 320) && (daydim == 200))
			setvmode(0x13);
		else if ((daxdim > 320) && (daydim > 200))
		{
			i = -1;
			if ((daxdim == 640) && (daydim == 400)) i = setvesamode(0x100);
			if ((daxdim == 640) && (daydim == 480)) i = setvesamode(0x101);
			if ((daxdim == 800) && (daydim == 600)) i = setvesamode(0x103);
			if ((daxdim == 1024) && (daydim == 768)) i = setvesamode(0x105);
			if ((daxdim == 1280) && (daydim == 1024)) i = setvesamode(0x107);
			if ((daxdim == 1600) && (daydim == 1200)) i = setvesamode(0x120);

			if (i == -1)
			{
				if (davidoption == 3)            //Special Tseng driver
				{
					if ((daxdim == 640) && (daydim == 480)) i = setvmode(0x2e);
					if ((daxdim == 800) && (daydim == 600)) i = setvmode(0x30);
					if ((daxdim == 1024) && (daydim == 768)) i = setvmode(0x38);

					vesapageshift = 6;
					tsengdriver = 1;
				}
				else
				{
					printf("Vesa NOT found / mode not supported\n");
					exit(0);
				}
			}
			if ((davidoption != 6) && (davidoption != 7)) davidoption = 1;
		}
		setpalette(curbrightness);
	}
	else if (xres != daxres)
		clearbuf(frameplace,(daxdim*daydim)>>2,0L);

	if ((xdim != daxdim) || (ydim != daydim))
	{
		setxdim(daxdim);

		searchx = (daxdim>>1);
		searchy = (daydim>>1);

		j = 0;
		for(i=0;i<MAXYDIM;i++) { ylookup[i] = j; j += daxdim; }
	}

	if (vidoption != davidoption)
	{
		switch(davidoption)
		{
			case 0: case 1:
				//koutp(0x3c4,0x4); koutp(0x3c5,0x6);
				//koutp(0x3d4,0x14); koutp(0x3d5,0x0);
				//koutp(0x3d4,0x17); koutp(0x3d5,0xe3);

				//koutp(0x3c4,2); koutp(0x3c5,15);
				//clearbuf(0xa0000,4096L+4096L+4096L+4096L,0L);

				//frameplace = 0xa0000;
				////fixvlinesforchain();
				//visualpage = 0;
				//break;
			case 2:
				frameplace = FP_OFF(screen)+(daxdim<<1);
				clearbuf(frameplace,(daxdim*daydim)>>2,0L);
				break;
			case 3:
				koutp(0x3cd,0), clearbuf(0xa0000,16000L,0L);
				koutp(0x3cd,1), clearbuf(0xa0000,16000L,0L);
				koutp(0x3cd,2), clearbuf(0xa0000,16000L,0L);
				koutp(0x3cd,3), clearbuf(0xa0000,16000L,0L);

				frameplace = 0xa0000;
				visualpage = 0; koutp(0x3cd,visualpage+(visualpage<<4));
				break;
			case 4:
				koutp(0x3ce,0xf); koutp(0x3cf,0x5);
				koutp(0x3d4,0x29); koutp(0x3d5,0x85);
				koutp(0x3c4,0x6); koutp(0x3c5,0x48);
				koutp(0x3d4,0x2f); koutp(0x3d5,0);   //set mod = 256k

				koutp(0x3ce,0x9); koutp(0x3cf,0<<4); clearbuf(0xa0000,16000L,0L);
				koutp(0x3ce,0x9); koutp(0x3cf,1<<4); clearbuf(0xa0000,16000L,0L);
				koutp(0x3ce,0x9); koutp(0x3cf,2<<4); clearbuf(0xa0000,16000L,0L);
				koutp(0x3ce,0x9); koutp(0x3cf,3<<4); clearbuf(0xa0000,16000L,0L);

				frameplace = 0xa0000; visualpage = 0; koutp(0x3ce,0x9); koutp(0x3cf,visualpage<<4);
				break;
			case 5:
				koutp(0x3d4,0x38); koutp(0x3d5,0x48);           //S3 Extensions enable #1
				koutp(0x3d4,0x39); koutp(0x3d5,0xa5);           //S3 Extensions enable #2
				koutp(0x3d4,0x31); koutp(0x3d5,kinp(0x3d5)|9);  //Init for start address

				koutp(0x3d4,0x35); koutp(0x3d5,0); clearbuf(0xa0000,16000L,0L);
				koutp(0x3d4,0x35); koutp(0x3d5,1); clearbuf(0xa0000,16000L,0L);
				koutp(0x3d4,0x35); koutp(0x3d5,2); clearbuf(0xa0000,16000L,0L);
				koutp(0x3d4,0x35); koutp(0x3d5,3); clearbuf(0xa0000,16000L,0L);

				frameplace = 0xa0000;
				visualpage = 0; koutp(0x3d4,0x35); koutp(0x3d5,visualpage);
				break;
			case 6:
				frameplace = FP_OFF(screen)+(daxdim<<1);
				clearbuf(frameplace,(daxdim*daydim)>>2,0L);
				stereoinit();
				break;
			case 7:
				frameplace = FP_OFF(screen)+(daxdim<<1);
				clearbuf(frameplace,(daxdim*daydim)>>2,0L);
				break;
		}
	}

	xreszoom = mulscale1(daxres,dazoom);
	xdimscale = divscale32(daxdim,daxdim*dazoom);
	ydimscale = divscale32(daydim,daxdim*dazoom);
	xdimscale1 = mulscale16(xdimscale,65536-daxpan);
	xdimscale2 = mulscale16(xdimscale,65536+daxpan);
	ydimscale1 = mulscale16(ydimscale,65536-daypan);
	ydimscale2 = mulscale16(ydimscale,65536+daypan);
	xdimup15 = (daxdim<<15)-mulscale1(daxpan,daxres);
	ydimup15 = (daydim<<15)-mulscale1(daypan,daxres);

	vidoption = davidoption;
	xdim = daxdim;
	ydim = daydim;
	xpan = daxpan;
	ypan = daypan;
	zoom = dazoom;
	xres = daxres;
}

nextpage()
{
	long i, totbytes, s1, s2;

	switch(vidoption)
	{
		case 0: case 1:
			koutp(0x3d4,0xc); koutp(0x3d5,visualpage<<6);
			visualpage = ((visualpage+1)&3);
			break;
		case 2:
			totbytes = xdim*ydim;
			for(i=0;i<totbytes;i+=65536)
			{
				if (tsengdriver == 1) koutp(0x3cd,i>>16); else vesasetpage(i>>16);

				if (i+65536 <= totbytes)
					copybuf(frameplace+i,0xa0000,16384);
				else
					copybuf(frameplace+i,0xa0000,(totbytes-i)>>2);
			}
			break;
		case 3:
			koutp(0x3d4,0xc); koutp(0x3d5,visualpage<<6);
			visualpage = ((visualpage+1)&3);
			koutp(0x3cd,visualpage+(visualpage<<4));
			break;
		case 4:
			koutp(0x3d4,0xc); koutp(0x3d5,visualpage<<6);
			visualpage = ((visualpage+1)&3);
			koutp(0x3ce,0x9); koutp(0x3cf,visualpage<<4);
			break;
		case 5:
			koutp(0x3d4,0xc); koutp(0x3d5,visualpage<<6);
			visualpage = ((visualpage+1)&3);
			koutp(0x3d4,0x35); koutp(0x3d5,visualpage);
			break;
		case 6:
			totbytes = xdim*ydim;
			s1 = (long)(&screen[xdim<<1]); s2 = s1+totbytes;
			stereoblit(s1,s2);
			break;
		case 7:
			totbytes = xdim*ydim;
			s1 = (long)(&screen[xdim<<1]); s2 = s1+totbytes;
			for(i=0;i<totbytes;i+=65536)
			{
				if (tsengdriver == 1) koutp(0x3cd,i>>16); else vesasetpage(i>>16);

				if (i+65536 <= totbytes)
					redblueblit(s1+i,s2+i,65536);
				else
					redblueblit(s1+i,s2+i,totbytes-i);
			}
			break;
	}
}

drawplane(long daplane)
{
	long i, j, index, z, zz, z0, z1, z2, npoints, bad;

	globplane = daplane; globpla = &plane[daplane];
	globstat = globpla->flags;
	globshade = globpla->shade;
	globtext = globpla->texture;

	bad = 0;
	npoints = linnum[globplane];
	i = linoff[globplane]+npoints-1;
	for(z=npoints-1;z>=0;z--)
	{
		point2[z] = lin2[i]-linoff[globplane];
		index = lin[i--];
		r[z].x = ri[index].x; r[z].y = ri[index].y; r[z].z = ri[index].z;
		if (r[z].z > 0) bad = 1;
	}
	if (bad == 0) return;

	if (reversemode == 1)
	{
		for(j=npoints-1;j>=0;j--) point2[j+npoints] = point2[j];
		for(j=0;j<npoints;j++) point2[point2[j+npoints]] = j;
	}

	if ((npoints = clippoly(npoints)) <= 2L) return;

	for(z=npoints-1;z>=0;z--)
	{
		if (klabs(r[z].z) < (16<<4)) return;
		project(r[z].x,r[z].y,r[z].z,&sc[z].x,&sc[z].y);

		if (sc[z].x < 0) sc[z].x = 0;
		if (sc[z].x >= (xdim<<16)) sc[z].x = (xdim<<16)-1;
		if (sc[z].y < 0) sc[z].y = 0;
		if (sc[z].y >= (ydim<<16)) sc[z].y = (ydim<<16)-1;
	}

	(*globdrawplanefunction)(npoints);
}

drawline(long x1, long y1, long x2, long y2, char col)
{
	long dx, dy, x, y, xinc, yinc, d1, d2, t, p, cnt;

	col = palookup[0][col];

	dx = x2-x1; dy = y2-y1;
	if (klabs(dx) > klabs(dy))
	{
		if (x1 > x2)
		{
			t = x1, x1 = x2, x2 = t;
			t = y1, y1 = y2, y2 = t;
		}
		d1 = ((x1+32768)>>16); d2 = ((x2+32768)>>16);
		p = d1+frameplace; cnt = d2-d1;
		yinc = divscale16(dy,dx);
		y = y1 + mulscale16((32768-x1)&65535,yinc);
		while (cnt > 0)
		{
			drawpixel(ylookup[y>>16]+p,col);
			y += yinc; p++; cnt--;
		}
	}
	else
	{
		if (dy == 0) return;

		if (y1 > y2)
		{
			t = x1, x1 = x2, x2 = t;
			t = y1, y1 = y2, y2 = t;
		}
		d1 = ((y1+32768)>>16); d2 = ((y2+32768)>>16);
		p = ylookup[d1]+frameplace; cnt = d2-d1;
		xinc = divscale16(dx,dy);
		x = x1 + mulscale16((32768-y1)&65535,xinc);
		while (cnt > 0)
		{
			drawpixel(p+(x>>16),col);
			x += xinc; p += xdim;
			cnt--;
		}
	}
}

setuprotate3d(short da1, short da2, short da3, long darc[9])
{
	long cosa1, sina1, cosa2, sina2, cosa3, sina3, c1c3, c1s3, s1c3, s1s3;

	cosa1 = sintable[(da1+512)&2047]; sina1 = sintable[da1&2047];
	cosa2 = sintable[(da2+512)&2047]; sina2 = sintable[da2&2047];
	cosa3 = sintable[(da3+512)&2047]; sina3 = sintable[da3&2047];

	c1c3 = cosa1*cosa3; c1s3 = cosa1*sina3;
	s1c3 = sina1*cosa3; s1s3 = sina1*sina3;
	darc[0] = mulscale14(s1s3,sina2) + c1c3;
	darc[1] = -mulscale14(c1s3,sina2) + s1c3;
	darc[2] = sina3*cosa2;
	darc[3] = -cosa2*sina1;
	darc[4] = cosa2*cosa1;
	darc[5] = (sina2<<14);
	darc[6] = mulscale14(s1c3,sina2) - c1s3;
	darc[7] = -mulscale14(c1c3,sina2) - s1s3;
	darc[8] = cosa3*cosa2;

	/*ox = -(xdim<<7); oy = -(ydim<<7); oz = (xdim<<7);
	cornx[0] = tmulscale28(ox,darc[0],oy,darc[1],oz,darc[2]);
	corny[0] = tmulscale28(ox,darc[3],oy,darc[4],oz,darc[5]);
	cornz[0] = tmulscale28(ox,darc[6],oy,darc[7],oz,darc[8]);
	ox = (xdim<<7); oy = -(ydim<<7); oz = (xdim<<7);
	cornx[1] = tmulscale28(ox,darc[0],oy,darc[1],oz,darc[2]);
	corny[1] = tmulscale28(ox,darc[3],oy,darc[4],oz,darc[5]);
	cornz[1] = tmulscale28(ox,darc[6],oy,darc[7],oz,darc[8]);
	ox = (xdim<<7); oy = (ydim<<7); oz = (xdim<<7);
	cornx[2] = tmulscale28(ox,darc[0],oy,darc[1],oz,darc[2]);
	corny[2] = tmulscale28(ox,darc[3],oy,darc[4],oz,darc[5]);
	cornz[2] = tmulscale28(ox,darc[6],oy,darc[7],oz,darc[8]);
	ox = -(xdim<<7); oy = (ydim<<7); oz = (xdim<<7);
	cornx[3] = tmulscale28(ox,darc[0],oy,darc[1],oz,darc[2]);
	corny[3] = tmulscale28(ox,darc[3],oy,darc[4],oz,darc[5]);
	cornz[3] = tmulscale28(ox,darc[6],oy,darc[7],oz,darc[8]);*/
}

addrotate3d(short da1, short da2, short da3, long darc[9], long daindex)
{
	long cosa1, sina1, cosa2, sina2, cosa3, sina3, c1c3, c1s3, s1c3, s1s3;
	long f[9], ox, oy, oz;

	cosa1 = sintable[(da1+512)&2047]; sina1 = sintable[da1&2047];
	cosa2 = sintable[(da2+512)&2047]; sina2 = sintable[da2&2047];
	cosa3 = sintable[(da3+512)&2047]; sina3 = sintable[da3&2047];

	c1c3 = cosa1*cosa3; c1s3 = cosa1*sina3;
	s1c3 = sina1*cosa3; s1s3 = sina1*sina3;
	f[0] = mulscale14(s1s3,sina2) + c1c3;
	f[1] = -mulscale14(c1s3,sina2) + s1c3;
	f[2] = sina3*cosa2;
	f[3] = -cosa2*sina1;
	f[4] = cosa2*cosa1;
	f[5] = (sina2<<14);
	f[6] = mulscale14(s1c3,sina2) - c1s3;
	f[7] = -mulscale14(c1c3,sina2) - s1s3;
	f[8] = cosa3*cosa2;

	if (daindex >= 0)
	{
		if (spri[daindex].xscale != 64)
		{
			f[0] = mulscale6(f[0],spri[daindex].xscale);
			f[3] = mulscale6(f[3],spri[daindex].xscale);
			f[6] = mulscale6(f[6],spri[daindex].xscale);
		}
		if (spri[daindex].yscale != 64)
		{
			f[1] = mulscale6(f[1],spri[daindex].yscale);
			f[4] = mulscale6(f[4],spri[daindex].yscale);
			f[7] = mulscale6(f[7],spri[daindex].yscale);
		}
		if (spri[daindex].zscale != 64)
		{
			f[2] = mulscale6(f[2],spri[daindex].zscale);
			f[5] = mulscale6(f[5],spri[daindex].zscale);
			f[8] = mulscale6(f[8],spri[daindex].zscale);
		}
	}

	ox = darc[0]; oy = darc[3]; oz = darc[6];
	darc[0] = tmulscale28(ox,f[0],oy,f[3],oz,f[6]);
	darc[3] = tmulscale28(ox,f[1],oy,f[4],oz,f[7]);
	darc[6] = tmulscale28(ox,f[2],oy,f[5],oz,f[8]);
	ox = darc[1]; oy = darc[4]; oz = darc[7];
	darc[1] = tmulscale28(ox,f[0],oy,f[3],oz,f[6]);
	darc[4] = tmulscale28(ox,f[1],oy,f[4],oz,f[7]);
	darc[7] = tmulscale28(ox,f[2],oy,f[5],oz,f[8]);
	ox = darc[2]; oy = darc[5]; oz = darc[8];
	darc[2] = tmulscale28(ox,f[0],oy,f[3],oz,f[6]);
	darc[5] = tmulscale28(ox,f[1],oy,f[4],oz,f[7]);
	darc[8] = tmulscale28(ox,f[2],oy,f[5],oz,f[8]);
}

qrotate3d (long *x, long *y, long *z)
{
	long ox, oy, oz;

	ox = *x; oy = *y; oz = *z;
	*x = 0; *y = 0; *z = 0;
	if (ox != 0)
	{
		*x = (*x) + mulscale28(ox,rc[0]);
		*y = (*y) + mulscale28(ox,rc[1]);
		*z = (*z) + mulscale28(ox,rc[2]);
	}
	if (oy != 0)
	{
		*x = (*x) + mulscale28(oy,rc[3]);
		*y = (*y) + mulscale28(oy,rc[4]);
		*z = (*z) + mulscale28(oy,rc[5]);
	}
	if (oz != 0)
	{
		*x = (*x) + mulscale28(oz,rc[6]);
		*y = (*y) + mulscale28(oz,rc[7]);
		*z = (*z) + mulscale28(oz,rc[8]);
	}
}

rotate3d (long *x, long *y, long *z)
{
	long ox, oy, oz;

	ox = *x; oy = *y; oz = *z;
	*x = tmulscale28(ox,rc[0],oy,rc[3],oz,rc[6]);
	*y = tmulscale28(ox,rc[1],oy,rc[4],oz,rc[7]);
	*z = tmulscale28(ox,rc[2],oy,rc[5],oz,rc[8]);
}

backrotate3d (long *x, long *y, long *z)
{
	long ox, oy, oz;

	ox = *x; oy = *y; oz = *z;
	*x = tmulscale28(ox,rc[0],oy,rc[1],oz,rc[2]);
	*y = tmulscale28(ox,rc[3],oy,rc[4],oz,rc[5]);
	*z = tmulscale28(ox,rc[6],oy,rc[7],oz,rc[8]);
}

project (long x, long y, long z, long *dasx, long *dasy)
{
	long t;

	t = divscale12(xreszoom,z);
	*dasx = mulscale12(x,t) + xdimup15;
	*dasy = mulscale12(y,t) + ydimup15;
}

clippoly (long npoints)
{
	long z, zz, s1, s2, t, npoints2, start2, z1, z2, z3, z4;

	npoints2 = 0; start2 = 0; z = 0; splitcnt = 0;
	do
	{
		s2 = -mulscale16(r[z].z,xdimscale1)-r[z].x;
		do
		{
			zz = point2[z]; point2[z] = -1;
			s1 = s2; s2 = -mulscale16(r[zz].z,xdimscale1)-r[zz].x;
			if (s1 < 0)
			{
				r2[npoints2].x = r[z].x; r2[npoints2].y = r[z].y; r2[npoints2].z = r[z].z;
				point22[npoints2] = npoints2+1; npoints2++;
			}
			if ((s1^s2) < 0)
			{
				t = divscale30(s1,s1-s2);
				r2[npoints2].x = r[z].x+mulscale30(r[zz].x-r[z].x,t);
				r2[npoints2].y = r[z].y+mulscale30(r[zz].y-r[z].y,t);
				r2[npoints2].z = r[z].z+mulscale30(r[zz].z-r[z].z,t);
				if (s1 < 0) split[splitcnt++] = npoints2;
				point22[npoints2] = npoints2+1;
				npoints2++;
			}
			z = zz;
		} while (point2[z] >= 0);

		if (npoints2 >= start2+3)
			point22[npoints2-1] = start2, start2 = npoints2;
		else
			npoints2 = start2;

		z = 1;
		while ((z < npoints) && (point2[z] < 0)) z++;
	} while (z < npoints);
	if (npoints2 <= 2) return(0);

	for(z=1;z<splitcnt;z++)
		for(zz=0;zz<z;zz++)
		{
			z1 = split[z]; z2 = point22[z1]; z3 = split[zz]; z4 = point22[z3];
			s1  = klabs(r2[z1].x-r2[z2].x)+klabs(r2[z1].y-r2[z2].y)+klabs(r2[z1].z-r2[z2].z);
			s1 += klabs(r2[z3].x-r2[z4].x)+klabs(r2[z3].y-r2[z4].y)+klabs(r2[z3].z-r2[z4].z);
			s2  = klabs(r2[z1].x-r2[z4].x)+klabs(r2[z1].y-r2[z4].y)+klabs(r2[z1].z-r2[z4].z);
			s2 += klabs(r2[z3].x-r2[z2].x)+klabs(r2[z3].y-r2[z2].y)+klabs(r2[z3].z-r2[z2].z);
			if (s2 < s1)
				{ t = point22[split[z]]; point22[split[z]] = point22[split[zz]]; point22[split[zz]] = t; }
		}


	npoints = 0; start2 = 0; z = 0; splitcnt = 0;
	do
	{
		s2 = r2[z].x-mulscale16(r2[z].z,xdimscale2);
		do
		{
			zz = point22[z]; point22[z] = -1;
			s1 = s2; s2 = r2[zz].x-mulscale16(r2[zz].z,xdimscale2);
			if (s1 < 0)
			{
				r[npoints].x = r2[z].x; r[npoints].y = r2[z].y; r[npoints].z = r2[z].z;
				point2[npoints] = npoints+1; npoints++;
			}
			if ((s1^s2) < 0)
			{
				t = divscale30(s1,s1-s2);
				r[npoints].x = r2[z].x+mulscale30(r2[zz].x-r2[z].x,t);
				r[npoints].y = r2[z].y+mulscale30(r2[zz].y-r2[z].y,t);
				r[npoints].z = r2[z].z+mulscale30(r2[zz].z-r2[z].z,t);
				if (s1 < 0) split[splitcnt++] = npoints;
				point2[npoints] = npoints+1;
				npoints++;
			}
			z = zz;
		} while (point22[z] >= 0);

		if (npoints >= start2+3)
			point2[npoints-1] = start2, start2 = npoints;
		else
			npoints = start2;

		z = 1;
		while ((z < npoints2) && (point22[z] < 0)) z++;
	} while (z < npoints2);
	if (npoints <= 2) return(0);

	for(z=1;z<splitcnt;z++)
		for(zz=0;zz<z;zz++)
		{
			z1 = split[z]; z2 = point2[z1]; z3 = split[zz]; z4 = point2[z3];
			s1  = klabs(r[z1].x-r[z2].x)+klabs(r[z1].y-r[z2].y)+klabs(r[z1].z-r[z2].z);
			s1 += klabs(r[z3].x-r[z4].x)+klabs(r[z3].y-r[z4].y)+klabs(r[z3].z-r[z4].z);
			s2  = klabs(r[z1].x-r[z4].x)+klabs(r[z1].y-r[z4].y)+klabs(r[z1].z-r[z4].z);
			s2 += klabs(r[z3].x-r[z2].x)+klabs(r[z3].y-r[z2].y)+klabs(r[z3].z-r[z2].z);
			if (s2 < s1)
				{ t = point2[split[z]]; point2[split[z]] = point2[split[zz]]; point2[split[zz]] = t; }
		}


	npoints2 = 0; start2 = 0; z = 0; splitcnt = 0;
	do
	{
		s2 = -mulscale16(r[z].z,ydimscale1)-r[z].y;
		do
		{
			zz = point2[z]; point2[z] = -1;
			s1 = s2; s2 = -mulscale16(r[zz].z,ydimscale1)-r[zz].y;
			if (s1 < 0)
			{
				r2[npoints2].x = r[z].x; r2[npoints2].y = r[z].y; r2[npoints2].z = r[z].z;
				point22[npoints2] = npoints2+1; npoints2++;
			}
			if ((s1^s2) < 0)
			{
				t = divscale30(s2,s2-s1);
				r2[npoints2].x = r[zz].x+mulscale30(r[z].x-r[zz].x,t);
				r2[npoints2].y = r[zz].y+mulscale30(r[z].y-r[zz].y,t);
				r2[npoints2].z = r[zz].z+mulscale30(r[z].z-r[zz].z,t);
				if (s1 < 0) split[splitcnt++] = npoints2;
				point22[npoints2] = npoints2+1;
				npoints2++;
			}
			z = zz;
		} while (point2[z] >= 0);

		if (npoints2 >= start2+3)
			point22[npoints2-1] = start2, start2 = npoints2;
		else
			npoints2 = start2;

		z = 1;
		while ((z < npoints) && (point2[z] < 0)) z++;
	} while (z < npoints);
	if (npoints2 <= 2) return(0);

	for(z=1;z<splitcnt;z++)
		for(zz=0;zz<z;zz++)
		{
			z1 = split[z]; z2 = point22[z1]; z3 = split[zz]; z4 = point22[z3];
			s1  = klabs(r2[z1].x-r2[z2].x)+klabs(r2[z1].y-r2[z2].y)+klabs(r2[z1].z-r2[z2].z);
			s1 += klabs(r2[z3].x-r2[z4].x)+klabs(r2[z3].y-r2[z4].y)+klabs(r2[z3].z-r2[z4].z);
			s2  = klabs(r2[z1].x-r2[z4].x)+klabs(r2[z1].y-r2[z4].y)+klabs(r2[z1].z-r2[z4].z);
			s2 += klabs(r2[z3].x-r2[z2].x)+klabs(r2[z3].y-r2[z2].y)+klabs(r2[z3].z-r2[z2].z);
			if (s2 < s1)
				{ t = point22[split[z]]; point22[split[z]] = point22[split[zz]]; point22[split[zz]] = t; }
		}


	npoints = 0; start2 = 0; z = 0; splitcnt = 0;
	do
	{
		s2 = r2[z].y-mulscale16(r2[z].z,ydimscale2);
		do
		{
			zz = point22[z]; point22[z] = -1;
			s1 = s2; s2 = r2[zz].y-mulscale16(r2[zz].z,ydimscale2);
			if (s1 < 0)
			{
				r[npoints].x = r2[z].x; r[npoints].y = r2[z].y; r[npoints].z = r2[z].z;
				point2[npoints] = npoints+1; npoints++;
			}
			if ((s1^s2) < 0)
			{
				t = divscale30(s2,s2-s1);
				r[npoints].x = r2[zz].x+mulscale30(r2[z].x-r2[zz].x,t);
				r[npoints].y = r2[zz].y+mulscale30(r2[z].y-r2[zz].y,t);
				r[npoints].z = r2[zz].z+mulscale30(r2[z].z-r2[zz].z,t);
				if (s1 < 0) split[splitcnt++] = npoints;
				point2[npoints] = npoints+1;
				npoints++;
			}
			z = zz;
		} while (point22[z] >= 0);

		if (npoints >= start2+3)
			point2[npoints-1] = start2, start2 = npoints;
		else
			npoints = start2;

		z = 1;
		while ((z < npoints2) && (point22[z] < 0)) z++;
	} while (z < npoints2);
	if (npoints <= 2) return(0);

	for(z=1;z<splitcnt;z++)
		for(zz=0;zz<z;zz++)
		{
			z1 = split[z]; z2 = point2[z1]; z3 = split[zz]; z4 = point2[z3];
			s1  = klabs(r[z1].x-r[z2].x)+klabs(r[z1].y-r[z2].y)+klabs(r[z1].z-r[z2].z);
			s1 += klabs(r[z3].x-r[z4].x)+klabs(r[z3].y-r[z4].y)+klabs(r[z3].z-r[z4].z);
			s2  = klabs(r[z1].x-r[z4].x)+klabs(r[z1].y-r[z4].y)+klabs(r[z1].z-r[z4].z);
			s2 += klabs(r[z3].x-r[z2].x)+klabs(r[z3].y-r[z2].y)+klabs(r[z3].z-r[z2].z);
			if (s2 < s1)
				{ t = point2[split[z]]; point2[split[z]] = point2[split[zz]]; point2[split[zz]] = t; }
		}

	return(npoints);
}

clipline (long *x1, long *y1, long *z1, long *x2, long *y2, long *z2)
{
	long t, templong;

	if ((*x1 < -*z1) != (*x2 < -*z2))
	{
		if (*x2 < -*z2)
		{
			templong = *x1; *x1 = *x2; *x2 = templong;
			templong = *y1; *y1 = *y2; *y2 = templong;
			templong = *z1; *z1 = *z2; *z2 = templong;
		}
		t = divscale16(*x1+*z1,*z1-*z2+*x1-*x2);
		*x1 = *x1+mulscale16(t,*x2-*x1);
		*y1 = *y1+mulscale16(t,*y2-*y1);
		*z1 = *z1+mulscale16(t,*z2-*z1);
	}
	else if (*x1 < -*z1)
		return(0);
	if ((*x1 > *z1) != (*x2 > *z2))
	{
		if (*x1 > *z1)
		{
			templong = *x1; *x1 = *x2; *x2 = templong;
			templong = *y1; *y1 = *y2; *y2 = templong;
			templong = *z1; *z1 = *z2; *z2 = templong;
		}
		t = divscale16(*x1-*z1,*z2-*z1+*x1-*x2);
		*x2 = *x1+mulscale16(t,*x2-*x1);
		*y2 = *y1+mulscale16(t,*y2-*y1);
		*z2 = *z1+mulscale16(t,*z2-*z1);
	}
	else if (*x1 > *z1)
		return(0);

	if ((*y1 < mulscale16(-*z1,ydimscale)) != (*y2 < mulscale16(-*z2,ydimscale)))
	{
		if (*y2 < mulscale16(-*z2,ydimscale))
		{
			templong = *x1; *x1 = *x2; *x2 = templong;
			templong = *y1; *y1 = *y2; *y2 = templong;
			templong = *z1; *z1 = *z2; *z2 = templong;
		}
		t = divscale16(*y1+mulscale16(*z1,ydimscale),mulscale16(*z1-*z2,ydimscale)+*y1-*y2);
		*x1 = *x1+mulscale16(t,*x2-*x1);
		*y1 = *y1+mulscale16(t,*y2-*y1);
		*z1 = *z1+mulscale16(t,*z2-*z1);
	}
	else if (*y1 < mulscale16(-*z1,ydimscale))
		return(0);

	if ((*y1 > mulscale16(*z1,ydimscale)) != (*y2 > mulscale16(*z2,ydimscale)))
	{
		if (*y1 > mulscale16(*z1,ydimscale))
		{
			templong = *x1; *x1 = *x2; *x2 = templong;
			templong = *y1; *y1 = *y2; *y2 = templong;
			templong = *z1; *z1 = *z2; *z2 = templong;
		}
		t = divscale16(*y1-mulscale16(*z1,ydimscale),mulscale16(*z2-*z1,ydimscale)+*y1-*y2);
		*x2 = *x1+mulscale16(t,*x2-*x1);
		*y2 = *y1+mulscale16(t,*y2-*y1);
		*z2 = *z1+mulscale16(t,*z2-*z1);
	}
	else if (*y1 > mulscale16(*z1,ydimscale))
		return(0);

	return(1);
}

setupgetreadpos()
{
	long x0, y0, z0, x1, y1, z1, x2, y2, z2;

	x0 = globpla->ox; y0 = globpla->oy; z0 = globpla->oz;
	x1 = globpla->ux; y1 = globpla->uy; z1 = globpla->uz;
	x2 = globpla->vx; y2 = globpla->vy; z2 = globpla->vz;

	if ((globstat&1) == 0) { x0 -= globx; y0 -= globy; z0 -= globz; }

	x0 <<= 8; y0 <<= 8; z0 <<= 8; rotate3d(&x0,&y0,&z0);
	x1 <<= 8; y1 <<= 8; z1 <<= 8; qrotate3d(&x1,&y1,&z1);
	x2 <<= 8; y2 <<= 8; z2 <<= 8; qrotate3d(&x2,&y2,&z2);

	//(x1-x0)*t + (x2-x0)*u + xv*(-v) = -x0
	//(y1-y0)*t + (y2-y0)*u + yv*(-v) = -y0
	//(z1-z0)*t + (z2-z0)*u + zv*(-v) = -z0

	getdxinc = dmulscale24(y1,z2,-y2,z1);
	getuxinc = dmulscale24(y2,z0,-y0,z2);
	getvxinc = dmulscale24(y0,z1,-y1,z0);
	getdyinc = dmulscale24(x2,z1,-x1,z2);
	getuyinc = dmulscale24(x0,z2,-x2,z0);
	getvyinc = dmulscale24(x1,z0,-x0,z1);

	getd = dmulscale24(x1,y2,-x2,y1);
	getu = dmulscale24(x2,y0,-x0,y2);
	getv = dmulscale24(x0,y1,-x1,y0);
	gett = tmulscale16(x0,getdxinc,x1,getuxinc,x2,getvxinc);

	getd = mulscale16(getd,xreszoom);
	getu = mulscale16(getu,xreszoom);
	getv = mulscale16(getv,xreszoom);
	gett = mulscale28(gett,xreszoom);

	globdax = xdimup15; globday = ydimup15;
}

getreadpos(long scrx, long scry, long *bx, long *by)
{
	long thed, thet, theu;

	scrx -= globdax; scry -= globday;
	thed = getd + dmulscale16(getdxinc,scrx,getdyinc,scry);
	thet = getu + dmulscale16(getuxinc,scrx,getuyinc,scry);
	theu = getv + dmulscale16(getvxinc,scrx,getvyinc,scry);

	if (thed <= 0) return;
	if ((klabs(thet)>>5) >= thed) return;
	if ((klabs(theu)>>5) >= thed) return;

	fpustartdivscale(thet,thed,26);
	//*bx = divscale26(thet,thed);
	*by = divscale26(theu,thed);
	*bx = fpugetdivide();
}

ksqrt(long num)
{
	return(ksqrtasm(num));
}

calcksqrt(long num)
{
	long root, temp;

	if (num < 0)
		return(-1);
	root = 128;
	do
	{
		temp = root;
		root = ((root+(num/root))>>1);
	}
	while (klabs(temp-root) > 1);
	return(root);
}

diaghline (long x1, long x2, long y)
{
	long y1, p, bx, by, t, scrx, scry;

	y1 = (y<<16) - (hplc[x1]<<16);

	scrx = x1-globdax;
	if (scrx != 0)
	{
		globdax = x1;
		getd += getdxinc*scrx;
		getu += getuxinc*scrx;
		getv += getvxinc*scrx;
	}
	scry = y1-globday;
	t = getd + mulscale16(getdyinc,scry);
	if ((reversemode == 0) && (t <= 512)) return;
	if ((reversemode == 1) && (t >= -512)) return;
	t = divscale(65536,t,24);
	bx = (mulscale8(t,getu + mulscale16(getuyinc,scry))&0xffffffc0);
	by = (mulscale8(t,getv + mulscale16(getvyinc,scry))&0xffffffc0);
	asm1 = mulscale8(t,globuadd);     //bxinc
	asm2 = mulscale8(t,globvadd);     //byinc

	asm3 = mulscale31(t,gett)+globshade;
	if (asm3 < 0) asm3 = 0;
	if (asm3 >= numpalookups) asm3 = numpalookups-1;
	asm3 = FP_OFF(palookup)+(asm3<<8);   //shadeoffs

	p = ylookup[y1>>16] + x1 + frameplace;

	if (globm == 0)
	{
		if ((globstat&2) == 0)
			hline(bx,by,x2-x1,0L,0L,p);
		else
			mhline(bx,by,x2-x1,0L,0L,p);
		return;
	}

	//yinc = -globm;
	//if (yinc < 0)
	//   yinc = -yinc, y1 ^= 65535;
	//y1 &= 65535;
	//if (yinc >= 65536)
	//   yinc = 65535, y1 = 65535;
	//asm4 = (yinc<<16);

	if ((globstat&2) == 0)
		dline(bx,by,x2-x1,x1<<2,0L,p);
	else
		mdline(bx,by,x2-x1,x1<<2,0L,p);

	//for(x=x1;x<=x2;x++)
	//{
	//   ptr = (char *)(picoffs+(((bx>>26)&63)<<6)+((by>>26)&63));
	//   drawpixel(p,palookup[shade][*ptr]);
	//   y += yinc;
	//   p += (pinc&(sign extend of carry));
	//   p++;
	//   bx += bxinc;
	//   by += byinc;
	//}
}

diagvline (long y1, long y2, long x)
{
	long x1, p, bx, by, t, scrx, scry, xinc;

	x1 = (x<<16) - (hplc[y1]<<16);

	scry = y1-globday;
	if (scry != 0)
	{
		globday = y1;
		getd += getdyinc*scry;
		getu += getuyinc*scry;
		getv += getvyinc*scry;
	}
	scrx = x1-globdax;
	t = getd + mulscale16(getdxinc,scrx);
	if ((reversemode == 0) && (t <= 512)) return;
	if ((reversemode == 1) && (t >= -512)) return;
	t = divscale(65536,t,24);
	bx = (mulscale8(t,getu + mulscale16(getuxinc,scrx))&0xffffffc0);
	by = (mulscale8(t,getv + mulscale16(getvxinc,scrx))&0xffffffc0);
	asm1 = mulscale8(t,globuadd);                 //bxinc
	asm2 = mulscale8(t,globvadd);                 //byinc

	asm3 = mulscale31(t,gett)+globshade;
	if (asm3 < 0) asm3 = 0;
	if (asm3 >= numpalookups) asm3 = numpalookups-1;
	asm3 = FP_OFF(palookup)+(asm3<<8);   //shadeoffs

	p = ylookup[y1] + (x1>>16) + frameplace;

	if (globm == 0)
	{
		if ((globstat&2) == 0)
			vline(bx,by,y2-y1,0L,0L,p);
		else
			mvline(bx,by,y2-y1,0L,0L,p);
		return;
	}

	//xinc = -globm;
	//if (xinc < 0)
	//   xinc = -xinc, x1 ^= 65535;
	//x1 &= 65535;
	//if (xinc >= 65536)
	//   xinc = 65535, x1 = 65535;
	//asm4 = (xinc<<16);

	if ((globstat&2) == 0)
		dline(bx,by,y2-y1,y1<<2,0L,p);
	else
		mdline(bx,by,y2-y1,y1<<2,0L,p);

	//for(y=y1;y<=y2;y++)
	//{
	//   ptr = (char *)(picoffs+(((bx>>26)&63)<<6)+((by>>26)&63));
	//   drawpixel(p,palookup[shade][*ptr]);
	//   x += xinc;
	//   p += xdim(+carry); (NOTE:  This is adc / sbb with the x += xinc)
	//   bx += bxinc;
	//   by += byinc;
	//}
}

void drawslowtextureplane(long npoints)
{
	long z, zz, zzz, x1, y1, x2, y2, miny, maxy, x, y, xinc, cnt;
	long i, col, p, lastp, dapicnum, dashade, bufplc, maskval1, maskval2;
	long bx, by, shval1, shval2, dat;
	short *sptr;
	char *ptr;

	setupgetreadpos();
	if ((getdxinc == 0) || (getdyinc == 0) || (klabs(getdxinc) == klabs(getdyinc)))
	{
		drawfasttextureplane(npoints);
		return;
	}

	miny = 0x7fffffff; maxy = 0x80000000;
	for(z=npoints-1;z>=0;z--)
		{ y = sc[z].y; miny = min(miny,y); maxy = max(maxy,y); }
	miny >>= 16; maxy >>= 16;
	for(y=miny;y<=maxy;y++) dotp[y] = (short *)(doti+(y*16));

	for(z=npoints-1;z>=0;z--)
	{
		zz = point2[z]; y1 = (sc[z].y>>16); y2 = (sc[zz].y>>16);
		if (y1 != y2)
		{
			x1 = sc[z].x; x2 = sc[zz].x;
			xinc = (x2-x1)/(y2-y1);
			if (y2 > y1)
				{ for(y=y1;y<y2;y++) { *dotp[y]++ = (x1>>16); x1 += xinc; } }
			else
				{ for(y=y2;y<y1;y++) { *dotp[y]++ = (x2>>16); x2 += xinc; } }
		}
	}

	dapicnum = globtext+animateoffs(globtext);
	if (waloff[dapicnum] == 0) loadtile(dapicnum);
	if (waloff[dapicnum] == 0) return;

	dashade = globshade+4;
	if (dashade < 0) dashade = 0;
	if (dashade >= numpalookups) dashade = numpalookups-1;

	ptr = (char *)(waloff[dapicnum]); col = *ptr;
	for(z=0;z<8;z++)
	{
		ptr++;
		i = *ptr;
		if (palette[(i<<1)+i]+palette[(i<<1)+i+1]+palette[(i<<1)+i+2] > palette[(col<<1)+col]+palette[(col<<1)+col+1]+palette[(col<<1)+col+2])
			col = i;
	}
	col = palookup[dashade][col];
	col += (col<<8);
	col += (col<<16);

	bufplc = waloff[dapicnum];

	maskval1 = ((1<<(picsiz[dapicnum]&15))-1);
	maskval2 = ((1<<(picsiz[dapicnum]>>4))-1);
	shval1 = 26-(picsiz[dapicnum]&15);
	shval2 = 26-(picsiz[dapicnum]>>4);
	maskval1 <<= 8;
	shval1 -= 8;

	sptr = (short *)(doti+(miny*16));
	for(y=miny;y<=maxy;y++)
	{
		cnt = dotp[y]-sptr;
		if (cnt != 0)
		{
			if (cnt > 2)
				for(z=cnt-1;z>0;z--)
					for(zz=z-1;zz>=0;zz--)
						if (sptr[z] < sptr[zz])
							zzz = sptr[z], sptr[z] = sptr[zz], sptr[zz] = zzz;
			for(zz=cnt-2;zz>=0;zz-=2)
			{
				x1 = sptr[zz]; x2 = sptr[zz+1];
				if (x1 != x2)
				{
					if (x1 > x2) z = x1, x1 = x2, x2 = z;

					zzz = (y<<16);
					p = frameplace + ylookup[y] + x1;
					if ((globstat&2) == 0)
					{
						for(lastp=x1;lastp<x2;lastp++)
						{
							getreadpos(lastp<<16,zzz,&bx,&by);
							ptr = (char *)(bufplc+((bx>>shval1)&maskval1)+((by>>shval2)&maskval2));
							dat = *ptr;
							drawpixel(p,dat);
							p++;
						}
					}
					else
					{
						for(lastp=x1;lastp<x2;lastp++)
						{
							getreadpos(lastp<<16,zzz,&bx,&by);
							ptr = (char *)(bufplc+((bx>>shval1)&maskval1)+((by>>shval2)&maskval2));
							dat = *ptr;
							if (dat != 255) drawpixel(p,dat);
							p++;
						}
					}
				}
			}
		}
		sptr += 16;
	}
}

xormousecursor()
{
	long i, p;

	for(i=1;i<=4;i++)
	{
		p = ylookup[searchy-i] + (searchx+0);
		vesasetpage(p>>16); p = 0xa0000+(p&65535); drawpixel(p,readpixel(p)^144);
		p = ylookup[searchy+0] + (searchx-i);
		vesasetpage(p>>16); p = 0xa0000+(p&65535); drawpixel(p,readpixel(p)^144);
		p = ylookup[searchy+0] + (searchx+i);
		vesasetpage(p>>16); p = 0xa0000+(p&65535); drawpixel(p,readpixel(p)^144);
		p = ylookup[searchy+i] + (searchx+0);
		vesasetpage(p>>16); p = 0xa0000+(p&65535); drawpixel(p,readpixel(p)^144);
	}
}

setvesamode(short vesamode)
{
	static struct rminfo
	{
		long EDI, ESI, EBP, ESP, EBX, EDX, ECX, EAX;
		short flags, ES, DS, FS, GS, IP, CS, SP, SS;
	} RMI;

	union REGS regs;
	struct SREGS sregs;
	short selector, segment;
	short *ptr, gran;

	memset(&sregs,0,sizeof(sregs));
	regs.w.ax = 0x0100;
	regs.w.bx = (256>>4);             //Number of paragraphs
	int386x(0x31,&regs,&regs,&sregs); // DPMI call 100h allocates DOS memory
	segment = regs.w.ax;
	selector = regs.w.dx;

	memset(&RMI,0,sizeof(RMI));    // Set up real-mode call structure
	RMI.EAX = 0x00004f01;
	RMI.ECX = (long)vesamode;
	RMI.ES = segment;
	RMI.EDI = 0;

	regs.w.ax = 0x0300;            // Use DMPI call 300h to issue the DOS interrupt
	regs.h.bl = 0x10;
	regs.h.bh = 0;
	regs.w.cx = 0;
	sregs.es = FP_SEG(&RMI);
	regs.x.edi = FP_OFF(&RMI);
	int386x(0x31,&regs,&regs,&sregs);

	if ((RMI.EAX&65535) != 0x004f)
		return(-1);

	ptr = (short *)((((long)segment)<<4)+4);
	gran = 64 / (*ptr);
	vesapageshift = 0;
	while (gran > 1)
	{
		vesapageshift++;
		gran >>= 1;
	}

	if (vesasetmode(vesamode) != 0x4f)
		return(-1);

	return(0);
}

draw3dclipline(long rx0, long ry0, long rz0, long rx1, long ry1, long rz1, char col)
{
	long sx0, sy0, sx1, sy1;

	rotate3d(&rx0,&ry0,&rz0);
	rotate3d(&rx1,&ry1,&rz1);

	if ((rz0 > 0) || (rz1 > 0))
	{
		if (clipline(&rx0,&ry0,&rz0,&rx1,&ry1,&rz1) == 1)
		{
			if ((rz0 > 16) && (rz1 > 16))
			{
				project(rx0,ry0,rz0,&sx0,&sy0);
				if (sx0 < 0) sx0 = 0;
				if (sx0 >= (xdim<<16)) sx0 = (xdim<<16)-1;
				if (sy0 < 0) sy0 = 0;
				if (sy0 >= (ydim<<16)) sy0 = (ydim<<16)-1;
				project(rx1,ry1,rz1,&sx1,&sy1);
				if (sx1 < 0) sx1 = 0;
				if (sx1 >= (xdim<<16)) sx1 = (xdim<<16)-1;
				if (sy1 < 0) sy1 = 0;
				if (sy1 >= (ydim<<16)) sy1 = (ydim<<16)-1;
				drawline(sx0,sy0,sx1,sy1,col);
			}
		}
	}
}

drawgrid()
{
	long x, y, z, xs, ys, zs, xe, ye, ze, xo, yo, zo, col;

	xs = globx-3072; xe = xs+6144;
	ys = globy-3072; ye = ys+6144;
	zs = globz-3072; ze = zs+6144;

	xo = (globx&511^511);
	yo = (globy&511^511);
	zo = (globz&511^511);

	for(x=xs+xo;x<=xe;x+=512)
	{
		draw3dclipline(x-globx,ys-globy,zs-globz,x-globx,ys-globy,ze-globz,6);
		draw3dclipline(x-globx,ys-globy,ze-globz,x-globx,ye-globy,ze-globz,6);
		draw3dclipline(x-globx,ye-globy,ze-globz,x-globx,ye-globy,zs-globz,6);
		draw3dclipline(x-globx,ye-globy,zs-globz,x-globx,ys-globy,zs-globz,6);
	}
	for(y=ys+yo;y<=ye;y+=512)
	{
		draw3dclipline(xs-globx,y-globy,zs-globz,xs-globx,y-globy,ze-globz,5);
		draw3dclipline(xs-globx,y-globy,ze-globz,xe-globx,y-globy,ze-globz,5);
		draw3dclipline(xe-globx,y-globy,ze-globz,xe-globx,y-globy,zs-globz,5);
		draw3dclipline(xe-globx,y-globy,zs-globz,xs-globx,y-globy,zs-globz,5);
	}
	for(z=zs+zo;z<=ze;z+=512)
	{
		draw3dclipline(xs-globx,ys-globy,z-globz,xs-globx,ye-globy,z-globz,4);
		draw3dclipline(xs-globx,ye-globy,z-globz,xe-globx,ye-globy,z-globz,4);
		draw3dclipline(xe-globx,ye-globy,z-globz,xe-globx,ys-globy,z-globz,4);
		draw3dclipline(xe-globx,ys-globy,z-globz,xs-globx,ys-globy,z-globz,4);
	}
}

gettile(short dapicnum)
{
	char *ptr;
	long xpicnum, ypicnum, xypicnum;
	short topleftpic;

	xpicnum = (xdim>>6);
	ypicnum = (ydim>>6);
	xypicnum = xpicnum*ypicnum;

	topleftpic = (dapicnum/xypicnum)*xypicnum;
	drawtilescreen(topleftpic);

	xormousecursor();
	while (1)
	{
		obstatus = bstatus, getmousevalues(&mousx,&mousy,&bstatus);
		if ((mousx|mousy) != 0)
		{
			xormousecursor();
			searchx += mousx;
			searchy += mousy;
			if (searchx < 4) searchx = 4;
			if (searchx >= xdim-4) searchx = xdim-4-1;
			if (searchy < 4) searchy = 4;
			if (searchy >= ydim-4) searchy = ydim-4-1;
			xormousecursor();
		}

		if (keystatus[0xcb] > 0)
		{
			keystatus[0xcb] = 0;
			xormousecursor();
			searchx -= 64;
			if (searchx < 4) searchx = 4;
			xormousecursor();
		}
		if (keystatus[0xcd] > 0)
		{
			keystatus[0xcd] = 0;
			xormousecursor();
			searchx += 64;
			if (searchx >= xdim-4) searchx = xdim-4-1;
			xormousecursor();
		}
		if (keystatus[0xc8] > 0)
		{
			keystatus[0xc8] = 0;
			xormousecursor();
			searchy -= 64;
			if (searchy < 4) searchy = 4;
			xormousecursor();
		}
		if (keystatus[0xd0] > 0)
		{
			keystatus[0xd0] = 0;
			xormousecursor();
			searchy += 64;
			if (searchx >= xdim-4) searchx = xdim-4-1;
			xormousecursor();
		}
		if (keystatus[0xc9] > 0)  //PGUP
		{
			if (topleftpic > 0)
			{
				topleftpic -= xypicnum;
				drawtilescreen(topleftpic);
				xormousecursor();
			}
			keystatus[0xc9] = 0;
		}
		if (keystatus[0xd1] > 0)  //PGDN
		{
			if (topleftpic < MAXTILES-xypicnum)
			{
				topleftpic += xypicnum;
				drawtilescreen(topleftpic);
				xormousecursor();
			}
			keystatus[0xd1] = 0;
		}

		if (keystatus[1] > 0)
		{
			keystatus[1] = 0;
			return(dapicnum);
		}
		if (keystatus[0x1c] > 0)
		{
			keystatus[0x1c] = 0;
			if ((searchx < (xpicnum<<6)) && (searchy < (ypicnum<<6)))
				dapicnum = topleftpic+(searchy>>6)*xpicnum+(searchx>>6);
			return(dapicnum);
		}

	}
}

drawtilescreen(short topleftpic)
{
	char *ptr;
	long i, j, xsiz, ysiz, ptrinc, x, y, p;
	short dapic;


	clearbuf(frameplace,(xdim*ydim)>>2,0x06070807);

		//Draw tiles on screen
	dapic = topleftpic;
	for(j=0;j<=ydim-64;j+=64)
		for(i=0;i<=xdim-64;i+=64)
		{
			xsiz = (long)tilesizx[dapic];
			ysiz = (long)tilesizy[dapic];
			if (waloff[dapic] == 0) loadtile(dapic);

			if ((xsiz > 0) && (ysiz > 0) && (waloff[dapic] != 0))
			{
				ptrinc = 1;
				while ((xsiz > 64) || (ysiz > 64))
				{
					xsiz >>= 1;
					ysiz >>= 1;
					ptrinc <<= 1;
				}
				if (xsiz > 64) xsiz = 64;
				if (ysiz > 64) ysiz = 64;

				for(x=0;x<xsiz;x++)
				{
					ptr = (char *)(waloff[dapic]+((x*ptrinc)<<8));
					p = frameplace+ylookup[j]+(x+i);

					if ((p < frameplace) || (p > frameplace+10000000))
					{
						for(i=0;i<ydim;i++)
							printf("%ld %x\n",i,ylookup[i]);
						exit(0);
					}

					for(y=0;y<ysiz;y++)
					{
						drawpixel(p,*ptr);
						p += xdim;
						ptr += ptrinc;
					}
				}
			}
			dapic++;
		}

	nextpage();

	//if (vidoption >= 3)
	//{
	//   visualpage = ((visualpage+3)&3);
	//   if (vidoption == 3) koutp(0x3cd,visualpage+(visualpage<<4));
	//   if (vidoption == 4) koutp(0x3ce,0x9), koutp(0x3cf,visualpage<<4);
	//   if (vidoption == 5) koutp(0x3d4,0x35), koutp(0x3d5,visualpage);
	//}
}

animateoffs(long tilenum)
{
	long i, k, offs;

	offs = 0;
	i = (baktotalclock>>((picanm[tilenum]>>24)&15));
	if ((picanm[tilenum]&63) > 0)
	{
		switch(picanm[tilenum]&192)
		{
			case 64:
				k = (i%((picanm[tilenum]&63)<<1));
				if (k < (picanm[tilenum]&63))
					offs = k;
				else
					offs = (((picanm[tilenum]&63)<<1)-k);
				break;
			case 128:
				offs = (i%((picanm[tilenum]&63)+1));
					break;
			case 192:
				offs = -(i%((picanm[tilenum]&63)+1));
		}
	}
	return(offs);
}

screencapture()
{
	char filename[15], *ptr;
	long fil, i, bufplc, xplc, yplc, col, ncol, leng, davesapage;

	strcpy(filename,"capturxx.pcx");
	filename[6] = (capturecount/10)+48;
	filename[7] = (capturecount%10)+48;
	if ((fil=open(filename,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY,S_IWRITE))==-1)
		return(-1);

	pcxheader[8] = ((xdim-1)&255); pcxheader[9] = (((xdim-1)>>8)&255);
	pcxheader[10] = ((ydim-1)&255); pcxheader[11] = (((ydim-1)>>8)&255);
	pcxheader[12] = (xdim&255); pcxheader[13] = ((xdim>>8)&255);
	pcxheader[14] = (ydim&255); pcxheader[15] = ((ydim>>8)&255);
	pcxheader[66] = (xdim&255); pcxheader[67] = ((xdim>>8)&255);

	write(fil,&pcxheader[0],128);

	davesapage = 0; vesasetpage(davesapage);
	ptr = (char *)0xa0000;

	xplc = 0; yplc = 0; bufplc = 0;
	while (yplc < ydim)
	{
		col = *ptr; ptr++;
		if (ptr >= 0xb0000)
			{ ptr -= 65536; davesapage++; vesasetpage(davesapage); }
		ncol = *ptr; leng = 1;
		xplc++; if (xplc >= xdim) { xplc = 0; yplc++; }
		while ((ncol == col) && (leng < 63) && (xplc != 0))
		{
			ptr++;
			if (ptr >= 0xb0000)
				{ ptr -= 65536; davesapage++; vesasetpage(davesapage); }
			ncol = *ptr; leng++;
			xplc++; if (xplc >= xdim) { xplc = 0; yplc++; }
		}
		if ((leng > 1) || (col >= 0xc0))
			savebyte(fil,tempbuf,bufplc,leng|0xc0);
		savebyte(fil,tempbuf,bufplc,col);
	}

	savebyte(fil,tempbuf,bufplc,0xc);

	koutp(0x3c7,0);
	for(i=0;i<768;i++)
		savebyte(fil,tempbuf,bufplc,kinp(0x3c9)<<2);

	if (bufplc > 0)
		if (write(fil,&tempbuf[0],bufplc) < bufplc)
			{ close(fil); return(-1); }

	close(fil);
	capturecount++;
	return(0);
}

resizelinnum(long daplane, long dapoints)
{
	long i, j, dachange;

	dachange = dapoints-linnum[daplane];
	if (dachange == 0) return;

	if (dachange < 0)
	{
		for(i=linoff[daplane];i<numlines;i++)
		{
			lin[i+dapoints] = lin[i+linnum[daplane]];
			lin2[i+dapoints] = lin2[i+linnum[daplane]]+dachange;
		}
	}
	else
	{
		for(i=numlines-1;i>=linoff[daplane];i--)
		{
			lin[i+dapoints] = lin[i+linnum[daplane]];
			lin2[i+dapoints] = lin2[i+linnum[daplane]]+dachange;
		}
	}
	numlines += dachange;

	linnum[daplane] = dapoints;
	for(i=daplane;i<numplanes;i++)
		linoff[i+1] = linoff[i]+linnum[i];
}

void drawsolidplane(long npoints)
{
	long z, zz, zzz, x1, y1, x2, y2, day1, day2, miny, maxy, x, y, xinc, cnt;
	long i, col, dapicnum, dashade;
	short *sptr;
	char *ptr;

	miny = 0x7fffffff; maxy = 0x80000000;
	for(z=npoints-1;z>=0;z--)
		{ y = sc[z].y; miny = min(miny,y); maxy = max(maxy,y); }
	miny = ((miny+32768)>>16); maxy = ((maxy+32768)>>16);
	for(y=miny;y<=maxy;y++) dotp[y] = (short *)(doti+(y*16));

	for(z=npoints-1;z>=0;z--)
	{
		zz = point2[z];
		y1 = sc[z].y; day1 = ((y1+32768)>>16);
		y2 = sc[zz].y; day2 = ((y2+32768)>>16);
		if (day1 != day2)
		{
			x1 = sc[z].x; x2 = sc[zz].x;
			if ((klabs(x2-x1)>>15) > klabs(y2-y1))
				xinc = 0x7fffffff + (((x2-x1)^(y2-y1)) < 0);
			else
				xinc = divscale16(x2-x1,y2-y1);
			if (day2 > day1)
			{
				x1 += mulscale16(((day1<<16)+32768)-y1,xinc) + 32768;
				for(y=day1;y<day2;y++) { *dotp[y]++ = (x1>>16); x1 += xinc; }
			}
			else
			{
				x2 += mulscale16(((day2<<16)+32768)-y2,xinc) + 32768;
				for(y=day2;y<day1;y++) { *dotp[y]++ = (x2>>16); x2 += xinc; }
			}
		}
	}

	dapicnum = globtext+animateoffs(globtext);
	if (waloff[dapicnum] == 0) loadtile(dapicnum);
	if (waloff[dapicnum] == 0) return;

	dashade = globshade+4;
	if (dashade < 0) dashade = 0;
	if (dashade >= numpalookups) dashade = numpalookups-1;

	ptr = (char *)(waloff[dapicnum]); col = *ptr;
	for(z=0;z<8;z++)
	{
		ptr++;
		i = *ptr;
		if (palette[(i<<1)+i]+palette[(i<<1)+i+1]+palette[(i<<1)+i+2] > palette[(col<<1)+col]+palette[(col<<1)+col+1]+palette[(col<<1)+col+2])
			col = i;
	}
	col = palookup[dashade][col];
	col += (col<<8);
	col += (col<<16);

	sptr = (short *)(doti+(miny*16));
	for(y=miny;y<=maxy;y++)
	{
		cnt = dotp[y]-sptr;
		if (cnt != 0)
		{
			if (cnt > 2)
				for(z=cnt-1;z>0;z--)
					for(zz=z-1;zz>=0;zz--)
						if (sptr[z] < sptr[zz])
							zzz = sptr[z], sptr[z] = sptr[zz], sptr[zz] = zzz;
			for(zz=cnt-2;zz>=0;zz-=2)
			{
				x1 = sptr[zz]; x2 = sptr[zz+1];
				if (x1 != x2)
				{
					if (x1 > x2) z = x1, x1 = x2, x2 = z;
					clearbufbyte(frameplace+ylookup[y]+x1,x2-x1,col);
				}
			}
		}
		sptr += 16;
	}
}

void drawwireplane(long npoints)
{
	long z, zz;

	for(z=0;z<npoints;z++)
	{
		zz = point2[z];
		drawline(sc[z].x,sc[z].y,sc[zz].x,sc[zz].y,79);
	}
}

clipmove (long *x, long *y, long *z, long xv, long yv, long zv)
{
	long i, cnt, xvect[4], yvect[4], zvect[4];

	getcliplanes (*x,*y,*z,xv,yv,zv);

	cnt = 3;
	do
	{
		xvect[cnt] = xv; yvect[cnt] = yv; zvect[cnt] = zv;

		raytrace(x,y,z,&xv,&yv,&zv);
		cnt--;

		for(i=cnt+1;i<3;i++)
			if (tmulscale6(xv,xvect[i],yv,yvect[i],zv,zvect[i]) < -1024)
				return;

	} while (((xv|yv|zv) != 0) && (cnt >= 0));
}

raytrace (long *x, long *y, long *z, long *xv, long *yv, long *zv)
{
	long goalx, goaly, goalz, intx, inty, intz, nintx, ninty, nintz;
	long clipplane, nx, ny, nz, x0, y0, z0, x1, y1, x2, y2, zx, zxx;
	long top, bot, daplane, topoverbot, cnt, templong, bad;
	long clipxoffs, clipyoffs, *ptr, closesttopoverbot;

	goalx = (*x) + (*xv); goaly = (*y) + (*yv); goalz = (*z) + (*zv);
	intx = goalx; inty = goaly; intz = goalz;

	clipplane = -1;
	closesttopoverbot = 0x7fffffff;

	for(daplane=cliplanes-1;daplane>=0;daplane--)
	{
		templong = cliplinoff[daplane];
		x0 = (*x)-clip[templong].x; nx = plane[cliplanum[daplane]].normal.x;
		y0 = (*y)-clip[templong].y; ny = plane[cliplanum[daplane]].normal.y;
		z0 = (*z)-clip[templong].z; nz = plane[cliplanum[daplane]].normal.z;
		bot = -tmulscale12(nx,*xv,ny,*yv,nz,*zv);
		top = tmulscale12(nx,x0,ny,y0,nz,z0);

		if ((top <= 0) && (bot < 0) && (top >= bot-256))
		{
			topoverbot = divscale24(top,bot);
			if (topoverbot-262144 < closesttopoverbot)
			{
				nintx = (*x) + mulscale24(*xv,topoverbot);
				ninty = (*y) + mulscale24(*yv,topoverbot);
				nintz = (*z) + mulscale24(*zv,topoverbot);

				//if (klabs(nintx-(*x))+klabs(ninty-(*y))+klabs(nintz-(*z)) < klabs(intx-(*x))+klabs(inty-(*y))+klabs(intz-(*z)))
				//{

				clipxoffs = (cliplinoff[daplane]<<2); clipyoffs = clipxoffs;
				if ((klabs(nz) > klabs(nx)) && (klabs(nz) > klabs(ny)))
				{
					x0 = nintx; clipxoffs += (long)&clip[0].x;
					y0 = ninty; clipyoffs += (long)&clip[0].y;
				}
				else if (klabs(ny) > klabs(nx))
				{
					x0 = nintx; clipxoffs += (long)&clip[0].x;
					y0 = nintz; clipyoffs += (long)&clip[0].z;
				}
				else
				{
					x0 = ninty; clipxoffs += (long)&clip[0].y;
					y0 = nintz; clipyoffs += (long)&clip[0].z;
				}

				cnt = 0;
				ptr = (long *)clipxoffs; x2 = *ptr;
				ptr = (long *)clipyoffs; y2 = *ptr;
				for(zx=0;zx<cliplinnum[daplane];zx++)
				{
					zxx = zx+1; if (zxx >= cliplinnum[daplane]) zxx = 0;
					zxx <<= 2;
					x1 = x2; ptr = (long *)(clipxoffs+zxx*3); x2 = *ptr;
					y1 = y2; ptr = (long *)(clipyoffs+zxx*3); y2 = *ptr;

					if ((x1 >= x0) || (x2 >= x0))
					{
						if (y1 <= y2)
						{
							if ((y1 <= y0) && (y2 > y0))
								if (x1*(y0-y2)+x2*(y1-y0) <= x0*(y1-y2))
									cnt ^= 1;
						}
						else
						{
							if ((y2 <= y0) && (y1 > y0))
								if (x2*(y0-y1)+x1*(y2-y0) <= x0*(y2-y1))
									cnt ^= 1;
						}
					}
				}

				if (cnt == 1)
				{
					templong = cliplinoff[daplane];
					x0 = clip[templong].x; y0 = clip[templong].y; z0 = clip[templong].z;
					cnt = 256;
					do
					{
						bad = tmulscale4(nx,nintx-x0,ny,ninty-y0,nz,nintz-z0);
						if (bad >= 0)
						{
							topoverbot -= 16384;
							nintx = (*x) + mulscale24(*xv,topoverbot);
							ninty = (*y) + mulscale24(*yv,topoverbot);
							nintz = (*z) + mulscale24(*zv,topoverbot);
							cnt--;
						}
					} while ((bad >= 0) && (cnt >= 0));

					if (topoverbot < closesttopoverbot)
					{
						closesttopoverbot = topoverbot;
						intx = nintx; inty = ninty; intz = nintz;
						clipplane = daplane;
					}
				}
			}
		}
	}

	if (clipplane == -1)
	{
		*xv = 0;
		*yv = 0;
		*zv = 0;
	}
	else
	{
		nx = plane[cliplanum[clipplane]].normal.x;
		ny = plane[cliplanum[clipplane]].normal.y;
		nz = plane[cliplanum[clipplane]].normal.z;
		bot = tmulscale16(nx,nx,ny,ny,nz,nz);
		if (bot != 0)
		{
			x0 = goalx-intx; y0 = goaly-inty; z0 = goalz-intz;
			top = tmulscale16(nx,x0,ny,y0,nz,z0);
			*xv = x0-scale(nx,top,bot)-ksgn(nx);
			*yv = y0-scale(ny,top,bot)-ksgn(ny);
			*zv = z0-scale(nz,top,bot)-ksgn(nz);
		}
	}

	*x = intx;
	*y = inty;
	*z = intz;
}

getcliplanes (long x1, long y1, long z1, long xv, long yv, long zv)
{
	long i, j, k, x2, y2, z2, templong, xmin, ymin, zmin, xmax, ymax, zmax;
	long nx, ny, nz, daplane, zx, i0, i1, i2, nx1, ny1, nz1, nx2, ny2, nz2;
	planetype *pla;

	x2 = x1+xv; y2 = y1+yv; z2 = z1+zv;

	if (x1 > x2) templong = x1, x1 = x2, x2 = templong;
	if (y1 > y2) templong = y1, y1 = y2, y2 = templong;
	if (z1 > z2) templong = z1, z1 = z2, z2 = templong;

	x1 -= (128+8); x2 += (128+8);
	y1 -= (128+8); y2 += (128+8);
	z1 -= (128+8); z2 += (128+8);

	clipoints = 0;
	cliplanes = 0;

	for(daplane=numplanes-1,pla=&plane[daplane];daplane>=0;daplane--,pla--)
		if ((pla->min.x <= x2) && (x1 <= pla->max.x))
			if ((pla->min.z <= z2) && (z1 <= pla->max.z))
				if ((pla->min.y <= y2) && (y1 <= pla->max.y))
					if ((pla->flags&4) == 0)
					{
						cliplanum[cliplanes] = daplane;
						cliplinoff[cliplanes] = clipoints;
						cliplinnum[cliplanes] = linnum[daplane];
						j = linoff[daplane];
						for(zx=j;zx<j+linnum[daplane];zx++)
						{
							k = lin[zx];
							clip[clipoints].x = p[k].x - (ksgn(pla->normal.x)<<7);
							clip[clipoints].y = p[k].y - (ksgn(pla->normal.y)<<7);
							clip[clipoints].z = p[k].z - (ksgn(pla->normal.z)<<7);
							clipoints++;
						}
						cliplanes++;
					}
}

hitscan (long *x, long *y, long *z, long xv, long yv, long zv)
{
	long startx, starty, startz, nintx, ninty, nintz, i0, i1, i2;
	long clipplane, nx, ny, nz, x0, y0, z0, x1, y1, z1, x2, y2, z2, zx, zxx;
	long top, bot, daplane, topoverbot, closesttopoverbot, cnt;
	long clipxoffs, clipyoffs, *ptr;

	startx = *x; starty = *y; startz = *z;

	clipplane = -1; closesttopoverbot = 0x7fffffff;
	for(daplane=0;daplane<numplanes;daplane++)
	{
		i0 = lin[linoff[daplane]+0];
		x0 = (startx-p[i0].x); y0 = (starty-p[i0].y); z0 = (startz-p[i0].z);

		nx = plane[daplane].normal.x; ny = plane[daplane].normal.y; nz = plane[daplane].normal.z;
		bot = -tmulscale12(nx,xv,ny,yv,nz,zv);
		top = tmulscale12(nx,x0,ny,y0,nz,z0);

		if ((top <= 0) && (bot < 0) && (top >= bot))
		{
			topoverbot = divscale24(top,bot);
			if (topoverbot < closesttopoverbot)
			{
				nintx = startx + mulscale24(xv,topoverbot);
				ninty = starty + mulscale24(yv,topoverbot);
				nintz = startz + mulscale24(zv,topoverbot);

				if ((klabs(nz) > klabs(nx)) && (klabs(nz) > klabs(ny)))
				{
					x0 = nintx; clipxoffs = (long)&p[0].x;
					y0 = ninty; clipyoffs = (long)&p[0].y;
				}
				else if (klabs(ny) > klabs(nx))
				{
					x0 = nintx; clipxoffs = (long)&p[0].x;
					y0 = nintz; clipyoffs = (long)&p[0].z;
				}
				else
				{
					x0 = ninty; clipxoffs = (long)&p[0].y;
					y0 = nintz; clipyoffs = (long)&p[0].z;
				}

				cnt = 0;
				zxx = (lin[linoff[daplane]]<<2);
				ptr = (long *)(clipxoffs+zxx*3); x2 = (*ptr)-x0;
				ptr = (long *)(clipyoffs+zxx*3); y2 = (*ptr)-y0;
				for(zx=0;zx<linnum[daplane];zx++)
				{
					zxx = zx+1; if (zxx >= linnum[daplane]) zxx = 0;
					zxx = (lin[linoff[daplane]+zxx]<<2);
					x1 = x2; ptr = (long *)(clipxoffs+zxx*3); x2 = (*ptr)-x0;
					y1 = y2; ptr = (long *)(clipyoffs+zxx*3); y2 = (*ptr)-y0;
					if ((y1^y2) < 0)
					{
						if ((x1^x2) < 0)
							cnt ^= (x1*y2<x2*y1)^(y1<y2);
						else if (x1 >= 0)
							cnt ^= 1;
					}
				}

				if (cnt == 1)
				{
					closesttopoverbot = topoverbot;
					*x = nintx; *y = ninty; *z = nintz;
					clipplane = daplane;
				}
			}
		}
	}

	return(clipplane);
}

recurseit(short z)
{
	grecpoi = &p[lin[linoff[z]]]; grecpla = &plane[z]; g2 = 0;
	if (grecpla->normal.x) g2 += mulscale8(grecpla->normal.x,globx-grecpoi->x);
	if (grecpla->normal.y) g2 += mulscale8(grecpla->normal.y,globy-grecpoi->y);
	if (grecpla->normal.z) g2 += mulscale8(grecpla->normal.z,globz-grecpoi->z);
	if (g2 <= 0)
	{
		if (grecpla->back >= 0) recurseit(grecpla->back);   //grecpla dies here
		else if (headspritesect[z+MAXPLANES] >= 0) drawsprisect((long)z+MAXPLANES);
		if (reversemode == 0) drawplane(z);
		if (plane[z].front >= 0) recurseit(plane[z].front);
		else if (headspritesect[z] >= 0) drawsprisect((long)z);
	}
	else
	{
		if (grecpla->front >= 0) recurseit(grecpla->front); //grecpla dies here
		else if (headspritesect[z] >= 0) drawsprisect((long)z);
		if (reversemode == 1) drawplane(z);
		if (plane[z].back >= 0) recurseit(plane[z].back);
		else if (headspritesect[z+MAXPLANES] >= 0) drawsprisect((long)z+MAXPLANES);
	}
}

checkinside(long x, long y, long z)
{
	long i, j, k;

	i = head;
	while(i >= 0)
	{
		j = lin[linoff[i]]; k = 0;
		if (plane[i].normal.x != 0) k += mulscale8(plane[i].normal.x,x-p[j].x);
		if (plane[i].normal.y != 0) k += mulscale8(plane[i].normal.y,y-p[j].y);
		if (plane[i].normal.z != 0) k += mulscale8(plane[i].normal.z,z-p[j].z);
		if (k <= 0) i = plane[i].front; else i = plane[i].back;
	}
	return(k<=0);
}

drawbspbox(short planum, char dacol)
{
	long p, dat;

	if (planum >= 4000) return;
	p = (((planum%80)+ylookup[planum/80])<<2)+0xa0000;

	dat = dacol+(dacol<<8); dat += (dat<<16);

	drawpixelses(p+0x0,dat^0x100d0f14);
	drawpixelses(p+320,dat^0x0d040611);
	drawpixelses(p+640,dat^0x0f060813);
	drawpixelses(p+960,dat^0x14111318);
}

makebsp()
{
	long i, j, k, z, zz, zx, zzx, bestz, minsplitnum, maxcnt;
	long splitnum, daplistindex, parentz, pnumplanes, xpnumplanes;
	long daplane, xmin, xmax, ymin, ymax, zmin, zmax;

	for(i=0;i<numplanes;i++)
	{
		plane[i].parent = -1, plane[i].plist = i;
		drawbspbox((short)i,whitecol);
	}

	pnumplanes = numplanes;
	while (pnumplanes > 0)
	{
		minsplitnum = 0x7fff; parentz = plane[plane[mulscale16(krand(),pnumplanes)].plist].parent;

		xpnumplanes = 0;
		for(zx=pnumplanes-1;zx>=0;zx--)
			if (plane[plane[zx].plist].parent == parentz)
				plane[xpnumplanes++].front = zx;          //Use front as temp here

		maxcnt = 32;
		while (maxcnt > 0)
		{
			zzx = plane[mulscale16(krand(),xpnumplanes)].front; z = plane[zzx].plist;

			splitnum = 0;
			for(zx=xpnumplanes-1;zx>=0;zx--)
			{
				zz = plane[plane[zx].front].plist;
				if (z != zz)
					if (planeside(z,zz) == 0)
					{
						splitnum++;
						if (splitnum >= minsplitnum) break;
					}
			}
			if (splitnum < minsplitnum)
			{
				bestz = z; daplistindex = zzx;
				if (splitnum == 0) break;
				minsplitnum = splitnum;
			}

			maxcnt--;
			if (maxcnt < 0) break;
		}
		z = bestz;

		for(zx=xpnumplanes-1;zx>=0;zx--)
		{
			zz = plane[plane[zx].front].plist;
			if (z != zz)
			{
				k = planeside(z,zz);
				if (k != 0)
					plane[zz].parent = z+((k<0)<<14);
				else
				{
					splitpoly(z,zz);   //Split plane segment zz by plane z
					plane[pnumplanes++].plist = numplanes-1;
					plane[zz].parent = z+16384; plane[numplanes-1].parent = z;
					drawbspbox((long)numplanes-1,whitecol^128);
				}
			}
		}

		if (keystatus[1] > 0)
		{
			setvmode(0x3);
			printf("Quit while making 3D bsp\n");
			exit(0);
		}

		drawbspbox(z,blackcol);

		pnumplanes--;
		plane[daplistindex].plist = plane[pnumplanes].plist;
	}

	for(z=0;z<numplanes;z++)
		plane[z].front = -1, plane[z].back = -1;

	head = -1;
	for(z=0;z<numplanes;z++)
	{
		if (plane[z].parent == -1)
			head = z;
		else if ((plane[z].parent&16384) != 0)
			plane[plane[z].parent&16383].back = z;
		else
			plane[plane[z].parent].front = z;
	}

	for(daplane=numplanes-1;daplane>=0;daplane--)
	{
		xmin = 0x7fffffff; xmax = 0x80000000;
		ymin = 0x7fffffff; ymax = 0x80000000;
		zmin = 0x7fffffff; zmax = 0x80000000;

		j = linoff[daplane];
		for(i=j+linnum[daplane]-1;i>=j;i--)
		{
			k = lin[i];
			if (p[k].x < xmin) xmin = p[k].x;
			if (p[k].y < ymin) ymin = p[k].y;
			if (p[k].z < zmin) zmin = p[k].z;
			if (p[k].x > xmax) xmax = p[k].x;
			if (p[k].y > ymax) ymax = p[k].y;
			if (p[k].z > zmax) zmax = p[k].z;
		}
		plane[daplane].min.x = xmin; plane[daplane].max.x = xmax;
		plane[daplane].min.y = ymin; plane[daplane].max.y = ymax;
		plane[daplane].min.z = zmin; plane[daplane].max.z = zmax;
	}
}

planeside (long z1, long z2)
{
	char sid;
	long z, zx, offsz1, zend;

	sid = 0; offsz1 = lin[linoff[z1]]; zend = linoff[z2]+linnum[z2];

	if (plane[z1].normal.y == 0)                 //Optimal cases for walls
	{
		if (plane[z1].normal.x == 0)
		{
			if (plane[z1].normal.z == 0)           //EVIL CASE!
				return(1);

			offsz1 = p[offsz1].z;
			if (plane[z1].normal.z > 0)
			{
				for(z=linoff[z2];z<zend;z++)
				{
					zx = p[lin[z]].z-offsz1;
					sid |= ((zx<0)+((zx>0)<<1));
				}
				if (sid == 3) return(0);
				if (sid == 2) return(-1);
				return(1);
			}
			for(z=linoff[z2];z<zend;z++)
			{
				zx = offsz1-p[lin[z]].z;
				sid |= ((zx<0)+((zx>0)<<1));
			}
			if (sid == 3) return(0);
			if (sid == 2) return(-1);
			return(1);
		}
		if (plane[z1].normal.z == 0)
		{
			offsz1 = p[offsz1].x;
			if (plane[z1].normal.x > 0)
			{
				for(z=linoff[z2];z<zend;z++)
				{
					zx = p[lin[z]].x-offsz1;
					sid |= ((zx<0)+((zx>0)<<1));
				}
				if (sid == 3) return(0);
				if (sid == 2) return(-1);
				return(1);
			}
			for(z=linoff[z2];z<zend;z++)
			{
				zx = offsz1-p[lin[z]].x;
				sid |= ((zx<0)+((zx>0)<<1));
			}
			if (sid == 3) return(0);
			if (sid == 2) return(-1);
			return(1);
		}
		for(z=linoff[z2];z<zend;z++)
		{
			zx = dmulscale8(plane[z1].normal.x,p[lin[z]].x-p[offsz1].x,
										plane[z1].normal.z,p[lin[z]].z-p[offsz1].z);
			sid |= ((zx<0)+((zx>0)<<1));
			if (sid == 3) return(0);
		}
		if (sid == 2) return(-1);
		return(1);
	}

	if ((plane[z1].normal.x|plane[z1].normal.z) == 0) //Optimal case for ceilings/floors
	{
		offsz1 = p[offsz1].y;
		if (plane[z1].normal.y > 0)
		{
			for(z=linoff[z2];z<zend;z++)
			{
				zx = p[lin[z]].y-offsz1;
				sid |= ((zx<0)+((zx>0)<<1));
			}
			if (sid == 3) return(0);
			if (sid == 2) return(-1);
			return(1);
		}
		for(z=linoff[z2];z<zend;z++)
		{
			zx = offsz1-p[lin[z]].y;
			sid |= ((zx<0)+((zx>0)<<1));
		}
		if (sid == 3) return(0);
		if (sid == 2) return(-1);
		return(1);
	}

		//General case (use this if rewrite needed)
	for(z=linoff[z2];z<zend;z++)
	{
		zx = tmulscale8(plane[z1].normal.x,p[lin[z]].x-p[offsz1].x,
							 plane[z1].normal.y,p[lin[z]].y-p[offsz1].y,
							 plane[z1].normal.z,p[lin[z]].z-p[offsz1].z);
		sid |= ((zx<0)+((zx>0)<<1));
		//if (zx < 0) sid |= 1;
		//if (zx > 0) sid |= 2;
		if (sid == 3) return(0);
	}
	if (sid == 2) return(-1);
	return(1);
}

splitpoly(long z, long zz)    //Split plane segment zz by plane z
{
	long i, j, k, s1, s2, t, intx, inty, intz, start2;
	long cx, cy, cz, nx, ny, nz, z1, z2, z3, z4;

		//Copy plane attributes
	memcpy(&plane[numplanes],&plane[zz],sizeof(plane[0]));

	t = lin[linoff[z]];
	cx = p[t].x; nx = plane[z].normal.x;
	cy = p[t].y; ny = plane[z].normal.y;
	cz = p[t].z; nz = plane[z].normal.z;

		//Calculate front plane segment
	linoff[numplanes] = numlines;
	start2 = numlines; splitcnt = 0; i = linoff[zz];
	do
	{
		t = lin[i]; s2 = tmulscale8(nx,p[t].x-cx,ny,p[t].y-cy,nz,p[t].z-cz);
		do
		{
			j = lin2[i]; lin2[i] |= 0x8000;

			s1 = s2;
			t = lin[j]; s2 = tmulscale8(nx,p[t].x-cx,ny,p[t].y-cy,nz,p[t].z-cz);

			if (s1 < 0)
			{
				lin2[numlines] = numlines+1;
				lin[numlines++] = lin[i];
			}
			if ((s1^s2) < 0)
			{
				intx = p[lin[i]].x + scale(p[lin[j]].x-p[lin[i]].x,s1,s1-s2);
				inty = p[lin[i]].y + scale(p[lin[j]].y-p[lin[i]].y,s1,s1-s2);
				intz = p[lin[i]].z + scale(p[lin[j]].z-p[lin[i]].z,s1,s1-s2);
				lin2[numlines] = numlines+1;
				lin[numlines] = newpoint(intx,inty,intz);
				if (s1 < 0) split[splitcnt++] = numlines;
				numlines++;
			}
			i = j;
		} while ((lin2[i]&0x8000) == 0);

		if (numlines >= start2+3)
			lin2[numlines-1] = start2, start2 = numlines;
		else
			numlines = start2;

		i = linoff[zz]+linnum[zz]-1;
		while ((i > linoff[zz]) && ((lin2[i]&0x8000) > 0)) i--;
	} while (i > linoff[zz]);

	for(i=1;i<splitcnt;i++)
		for(j=0;j<i;j++)
		{
			z1 = split[i]; z2 = lin2[z1]; z3 = split[j]; z4 = lin2[z3];
			z1 = lin[z1]; z2 = lin[z2]; z3 = lin[z3]; z4 = lin[z4];
			s1  = klabs(p[z1].x-p[z2].x)+klabs(p[z1].y-p[z2].y)+klabs(p[z1].z-p[z2].z);
			s1 += klabs(p[z3].x-p[z4].x)+klabs(p[z3].y-p[z4].y)+klabs(p[z3].z-p[z4].z);
			s2  = klabs(p[z1].x-p[z4].x)+klabs(p[z1].y-p[z4].y)+klabs(p[z1].z-p[z4].z);
			s2 += klabs(p[z3].x-p[z2].x)+klabs(p[z3].y-p[z2].y)+klabs(p[z3].z-p[z2].z);
			if (s2 < s1)
			{ t = lin2[split[i]]; lin2[split[i]] = lin2[split[j]]; lin2[split[j]] = t; }
		}

	linnum[numplanes] = numlines-linoff[numplanes];
	numplanes++;

		//Fix lin2's
	for(i=linoff[zz]+linnum[zz]-1;i>=linoff[zz];i--) lin2[i] &= ~0x8000;

		//Calculate back plane segment
	linoff[numplanes] = numlines;
	start2 = numlines; splitcnt = 0; i = linoff[zz];
	do
	{
		t = lin[i]; s2 = tmulscale8(nx,cx-p[t].x,ny,cy-p[t].y,nz,cz-p[t].z);
		do
		{
			j = lin2[i]; lin2[i] |= 0x8000;

			s1 = s2;
			t = lin[j]; s2 = tmulscale8(nx,cx-p[t].x,ny,cy-p[t].y,nz,cz-p[t].z);

			if (s1 < 0)
			{
				lin2[numlines] = numlines+1;
				lin[numlines++] = lin[i];
			}
			if ((s1^s2) < 0)
			{
				intx = p[lin[i]].x + scale(p[lin[j]].x-p[lin[i]].x,s1,s1-s2);
				inty = p[lin[i]].y + scale(p[lin[j]].y-p[lin[i]].y,s1,s1-s2);
				intz = p[lin[i]].z + scale(p[lin[j]].z-p[lin[i]].z,s1,s1-s2);
				lin2[numlines] = numlines+1;
				lin[numlines] = newpoint(intx,inty,intz);
				if (s1 < 0) split[splitcnt++] = numlines;
				numlines++;
			}

			i = j;
		} while ((lin2[i]&0x8000) == 0);

		if (numlines >= start2+3)
			lin2[numlines-1] = start2, start2 = numlines;
		else
			numlines = start2;

		i = linoff[zz]+linnum[zz]-1;
		while ((i > linoff[zz]) && ((lin2[i]&0x8000) > 0)) i--;
	} while (i > linoff[zz]);

	for(i=1;i<splitcnt;i++)
		for(j=0;j<i;j++)
		{
			z1 = split[i]; z2 = lin2[z1]; z3 = split[j]; z4 = lin2[z3];
			z1 = lin[z1]; z2 = lin[z2]; z3 = lin[z3]; z4 = lin[z4];
			s1  = klabs(p[z1].x-p[z2].x)+klabs(p[z1].y-p[z2].y)+klabs(p[z1].z-p[z2].z);
			s1 += klabs(p[z3].x-p[z4].x)+klabs(p[z3].y-p[z4].y)+klabs(p[z3].z-p[z4].z);
			s2  = klabs(p[z1].x-p[z4].x)+klabs(p[z1].y-p[z4].y)+klabs(p[z1].z-p[z4].z);
			s2 += klabs(p[z3].x-p[z2].x)+klabs(p[z3].y-p[z2].y)+klabs(p[z3].z-p[z2].z);
			if (s2 < s1)
				{ t = lin2[split[i]]; lin2[split[i]] = lin2[split[j]]; lin2[split[j]] = t; }
		}

	linnum[numplanes] = numlines-linoff[numplanes];
	numplanes++;

	linoff[numplanes] = numlines;

		//Resize for copying back plane into original
	resizelinnum(zz,(long)linnum[numplanes-1]);

		//Delete back plane
	numplanes--; numlines -= linnum[numplanes];

		//Copy back plane into original spot
	j = linoff[zz]-linoff[numplanes];
	for(i=linnum[numplanes]-1;i>=0;i--)
	{
		lin[i+linoff[zz]] = lin[i+linoff[numplanes]];
		lin2[i+linoff[zz]] = lin2[i+linoff[numplanes]]+j;
	}
}

setpalette(long dabrightness)
{
	char *ptr;
	long i, j, dist, daval;

	if (dabrightness < 0) dabrightness = 0;
	if (dabrightness > 15) dabrightness = 15;

	if (vidoption == 7)
	{
		if (curbrightness != dabrightness)
		{
			for(i=0;i<256;i++)
			{
				dist = palette[i*3]+palette[i*3+1]+palette[i*3+2];
				dist >>= 1;
				ptr = (char *)(FP_OFF(palookup[0])+i);
				for(j=0;j<32;j++)
				{
					daval = ((dist*(31-j))>>7);
					if (daval > 15) daval = 15;
					*ptr = daval;
					ptr += 256;
				}
			}
		}

		koutp(0x3c8,0);
		for(j=0;j<16;j++)
			for(i=0;i<16;i++)
			{
				koutp(0x3c9,britable[dabrightness][i<<2]);
				koutp(0x3c9,0);
				koutp(0x3c9,britable[dabrightness][j<<2]);
			}
	}
	else
	{
		koutp(0x3c8,0);
		for(i=0;i<768;i++)
			koutp(0x3c9,britable[dabrightness][palette[i]]);
	}
	curbrightness = dabrightness;
}

stereoinit()
{
	long i;

	setverts(510L,487L,0L,479L,12L,479L);

	outp(0x3d4,0x38); outp(0x3d5,0x48);           //S3 Extensions enable #1
	outp(0x3d4,0x39); outp(0x3d5,0xa5);           //S3 Extensions enable #2
	outp(0x3d4,0x31); outp(0x3d5,inp(0x3d5)|9);   //Init for start address

	outp(0x3d4,0x9); outp(0x3d5,inp(0x3d5)&(255-1));

	for(i=0;i<4;i++)
	{
		outp(0x3d4,0x35); outp(0x3d5,i); clearbuf(0xa0000,65536>>2,0L);
	}
}

setverts(long vertotal, long startverblank, long endverblank,
			long veretstart, long veretend, long verdispenab)
{
	char oflow;

	outp(0x3d4,0x11); outp(0x3d5,inp(0x3d5)&127);
	outp(0x3d4,0x6); outp(0x3d5,vertotal&255);

	oflow = 0;
	oflow += ((vertotal&256)>>8);
	oflow += ((verdispenab&256)>>7);
	oflow += ((veretstart&256)>>6);
	oflow += ((startverblank&256)>>5);
	oflow += ((vertotal&512)>>4);
	oflow += ((verdispenab&512)>>3);
	oflow += ((veretstart&512)>>2);
	outp(0x3d4,0x7); outp(0x3d5,(inp(0x3d5)&0x10)|oflow);

	outp(0x3d4,0x9); outp(0x3d5,(inp(0x3d5)&(255-32))|((startverblank&512)>>4));
	outp(0x3d4,0x10); outp(0x3d5,veretstart&255);
	outp(0x3d4,0x11); outp(0x3d5,(inp(0x3d5)&0xf0)+(veretend&15));
	outp(0x3d4,0x12); outp(0x3d5,verdispenab&255);
	outp(0x3d4,0x15); outp(0x3d5,startverblank&255);
	outp(0x3d4,0x16); outp(0x3d5,endverblank&255);

	outp(0x3d4,0x9); outp(0x3d5,inp(0x3d5)&(255-1));
}

stereoblit(long stereobuf1, long stereobuf2)
{
	outp(0x3d4,0x35); outp(0x3d5,visualpage+0); copybuf(stereobuf1,0xa0000,64000>>2);
	outp(0x3d4,0x35); outp(0x3d5,visualpage+1); copybuf(stereobuf2,0xa4000,49152>>2);
	outp(0x3d4,0x35); outp(0x3d5,visualpage+2); copybuf(stereobuf2+49152,0xa0000,14848>>2);
}

printext256(long xpos, long ypos, short col, short backcol, char name[82], char fontsize)
{
	char *fontptr;
	short dat, dacol;
	long stx, zx, stupidbitoffset, x, y, charxsiz;

	stx = xpos;

	if (fontsize == 1)
	{
		fontptr = smalltextfont;
		charxsiz = 4;
		stupidbitoffset = 1;
	}
	else
	{
		fontptr = textfont;
		charxsiz = 8;
		stupidbitoffset = 0;
	}

	for(zx=0;zx<strlen(name);zx++)
	{
		dat = name[zx];

		for(y=0;y<8;y++)
			for(x=0;x<charxsiz;x++)
			{
				if ((fontptr[(dat<<3)+y]&(1<<(7-stupidbitoffset-x))) > 0)
					dacol = (short)col;
				else if (backcol >= 0)
					dacol = (short)backcol;
				else
					dacol = -1;

				if (dacol >= 0)
					drawpixel(ylookup[y+ypos]+(x+stx-stupidbitoffset)+frameplace,(long)dacol);
			}

		stx += charxsiz;
	}
}

load3d(char *filename)
{
	long i, j, k, m, fil, x, y, z, minval, maxval, scaleval, oval;
	long x1, y1, z1, x2, y2, z2;
	long startsnumpoints, startsnumplanes, startsnumobjects, tempbufcnt;
	short danumpoints, danumplanes, danumobjects, dashort;
	signed char ch;

	if ((fil = open(filename,O_BINARY|O_RDONLY,S_IREAD)) == -1) return(-1);

	startsnumpoints = snumpoints;
	startsnumplanes = snumplanes;
	startsnumobjects = snumobjects;

	tempbufcnt = 0; read(fil,tempbuf,4096);

	danumobjects = tempbuf[tempbufcnt++];
	if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
	danumobjects += (tempbuf[tempbufcnt++]<<8);
	if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }

	for(k=0;k<danumobjects;k++)
	{
		danumpoints = tempbuf[tempbufcnt++];
		if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
		danumpoints += (tempbuf[tempbufcnt++]<<8);
		if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }

		dashort = 0;
		for(i=0;i<danumpoints;i++)
		{
			oval = tempbuf[tempbufcnt++];
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			oval += (tempbuf[tempbufcnt++]<<8);
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			dashort += oval;
			sp[i+snumpoints].x = (long)dashort;
		}

		dashort = 0;
		for(i=0;i<danumpoints;i++)
		{
			oval = tempbuf[tempbufcnt++];
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			oval += (tempbuf[tempbufcnt++]<<8);
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			dashort += oval;
			sp[i+snumpoints].y = (long)dashort;
		}

		dashort = 0;
		for(i=0;i<danumpoints;i++)
		{
			oval = tempbuf[tempbufcnt++];
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			oval += (tempbuf[tempbufcnt++]<<8);
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			dashort += oval;
			sp[i+snumpoints].z = (long)dashort;
		}

		danumplanes = tempbuf[tempbufcnt++];
		if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
		danumplanes += (tempbuf[tempbufcnt++]<<8);
		if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }

		oval = 0;
		for(i=0;i<danumplanes;i++)
		{
			ch = tempbuf[tempbufcnt++];
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			if (ch == 0x80)
			{
				oval = tempbuf[tempbufcnt++];
				if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
				oval += (tempbuf[tempbufcnt++]<<8);
				if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			}
			else
				oval += (long)ch;
			sp1[i+snumplanes] = oval;
		}

		oval = 0;
		for(i=0;i<danumplanes;i++)
		{
			ch = tempbuf[tempbufcnt++];
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			if (ch == 0x80)
			{
				oval = tempbuf[tempbufcnt++];
				if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
				oval += (tempbuf[tempbufcnt++]<<8);
				if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			}
			else
				oval += (long)ch;
			sp2[i+snumplanes] = oval;
		}

		oval = 0;
		for(i=0;i<danumplanes;i++)
		{
			ch = tempbuf[tempbufcnt++];
			if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			if (ch == 0x80)
			{
				oval = tempbuf[tempbufcnt++];
				if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
				oval += (tempbuf[tempbufcnt++]<<8);
				if (tempbufcnt >= 4096) { read(fil,tempbuf,4096); tempbufcnt = 0; }
			}
			else
				oval += (long)ch;
			sp3[i+snumplanes] = oval;
		}

		if ((danumpoints > 0) && (danumplanes > 0))
		{
			planeoff[snumobjects] = snumplanes;
			pointoff[snumobjects] = snumpoints;
			snumplanes += danumplanes;
			snumpoints += danumpoints;
			snumobjects++;
		}
	}
	planeoff[snumobjects] = snumplanes;
	pointoff[snumobjects] = snumpoints;

	if (snumpoints > startsnumpoints)
	{
		x = 0; y = 0; z = 0;
		for(i=startsnumpoints;i<snumpoints;i++) x += sp[i].x, y += sp[i].y, z += sp[i].z;
		x /= snumpoints, y /= snumpoints, z /= snumpoints;

		for(i=startsnumpoints;i<snumpoints;i++)
			sp[i].x -= x, sp[i].y -= y, sp[i].z -= z;

		minval = 0x7fffffff; maxval = 0x80000000;
		for(i=startsnumpoints;i<snumpoints;i++)
		{
			if (sp[i].x < minval) minval = sp[i].x;
			if (sp[i].x > maxval) maxval = sp[i].x;
			if (sp[i].y < minval) minval = sp[i].y;
			if (sp[i].y > maxval) maxval = sp[i].y;
			if (sp[i].z < minval) minval = sp[i].z;
			if (sp[i].z > maxval) maxval = sp[i].z;
		}

		scaleval = (65536*2048)/(maxval-minval);
		for(i=startsnumpoints;i<snumpoints;i++)
		{
			sp[i].x = mulscale16(sp[i].x,scaleval);
			sp[i].y = mulscale16(sp[i].y,scaleval);
			sp[i].z = mulscale16(sp[i].z,scaleval);
		}
	}

	for(i=startsnumobjects;i<snumobjects;i++)
	{
		x = 0, y = 0, z = 0;
		for(j=pointoff[i];j<pointoff[i+1];j++)
			x += sp[j].x, y += sp[j].y, z += sp[j].z;

		scaleval = pointoff[i+1]-pointoff[i];
		so[i].x = x/scaleval;
		so[i].y = y/scaleval;
		so[i].z = z/scaleval;

		for(j=pointoff[i];j<pointoff[i+1];j++)
			sp[j].x -= so[i].x, sp[j].y -= so[i].y, sp[j].z -= so[i].z;

		for(j=planeoff[i];j<planeoff[i+1];j++)
		{
			k = pointoff[i];
			m = sp1[j]+k; x = sp[m].x; y = sp[m].y; z = sp[m].z;
			m = sp2[j]+k; x1 = sp[m].x-x; y1 = sp[m].y-y; z1 = sp[m].z-z;
			m = sp3[j]+k; x2 = sp[m].x-x; y2 = sp[m].y-y; z2 = sp[m].z-z;
			x = dmulscale2(y1,z2,-y2,z1);
			y = dmulscale2(x2,z1,-x1,z2);
			z = dmulscale2(x1,y2,-x2,y1);
			reduce(x,y,z,32768);
			k = ksqrtasm(x*x+y*y+z*z);
			if (k > 0)
			{
				k = (65536*8192*3)/k;
				sn[j].x = mulscale16(x,k);
				sn[j].y = mulscale16(y,k);
				sn[j].z = mulscale16(z,k);
			}
		}
	}

	groupoff[snumgroups++] = startsnumobjects;
	groupoff[snumgroups] = snumobjects;

	close(fil);
	return(0);
}

drawsprisect(long sectnum)
{
	long i, ii, j, k, m, o, templong, temp, gap, dasprinum;
	long x, y, z, dax, day, daz, xvect, yvect, zvect, dashade;
	long x1, y1, z1, x2, y2, z2;

	switch(spritedrawmode)
	{
		case 0:
			for(i=headspritesect[sectnum];i>=0;i=nextspritesect[i])
				if ((spri[i].xscale != 0) && (spri[i].yscale != 0) && (spri[i].zscale != 0))
				{
					o = spri[i].objnum;

					xvect = so[o].x+spri[i].x-globx;
					yvect = so[o].y+spri[i].y-globy;
					zvect = so[o].z+spri[i].z-globz;
					rotate3d(&xvect,&yvect,&zvect);
					addrotate3d(spri[i].a1,spri[i].a2,spri[i].a3,rc,i);
					for(j=pointoff[o];j<pointoff[o+1];j++)
					{
						dax = sp[j].x; day = sp[j].y; daz = sp[j].z;
						rotate3d(&dax,&day,&daz);
						dax += xvect; day += yvect; daz += zvect;
						if (daz > 4)
						{
							projectlo(dax,day,daz,&x,&y);
							if ((x|y) >= 0)
								if ((x < xdim) && (y < ydim))
									drawpixel(ylookup[y]+x+frameplace,palookup[0][15]);
						}
					}
					copybuf(rc2,rc,9);
				}
			break;
		case 1:
			for(i=headspritesect[sectnum];i>=0;i=nextspritesect[i])
				if ((spri[i].xscale != 0) && (spri[i].yscale != 0) && (spri[i].zscale != 0))
				{
					o = spri[i].objnum;
					xvect = so[o].x+spri[i].x-globx;
					yvect = so[o].y+spri[i].y-globy;
					zvect = so[o].z+spri[i].z-globz;
					rotate3d(&xvect,&yvect,&zvect);
					addrotate3d(spri[i].a1,spri[i].a2,spri[i].a3,rc,i);
					k = 0;
					for(j=pointoff[o];j<pointoff[o+1];j++)
					{
						dax = sp[j].x; day = sp[j].y; daz = sp[j].z;
						rotate3d(&dax,&day,&daz);
						dax += xvect; day += yvect; daz += zvect;
						if (daz > 4)
						{
							projectlo(dax,day,daz,&sc[k].x,&sc[k].y);
							if (sc[k].x < 0) sc[k].x = 0;
							if (sc[k].x >= xdim) sc[k].x = xdim-1;
							if (sc[k].y < 0) sc[k].y = 0;
							if (sc[k].y >= ydim) sc[k].y = ydim-1;
						}
						else
							sc[k].x = 0x80000000;
						k++;
					}
					copybuf(rc2,rc,9);
					for(j=planeoff[o];j<planeoff[o+1];j++)
						if ((sc[sp1[j]].x != 0x80000000) && (sc[sp2[j]].x != 0x80000000) && (sc[sp3[j]].x != 0x80000000))
						{
							templong = palookup[0][((i&7)<<5)+23];
							drawline(sc[sp1[j]].x<<16,sc[sp1[j]].y<<16,sc[sp2[j]].x<<16,sc[sp2[j]].y<<16,(char)templong);
							drawline(sc[sp2[j]].x<<16,sc[sp2[j]].y<<16,sc[sp3[j]].x<<16,sc[sp3[j]].y<<16,(char)templong);
							drawline(sc[sp3[j]].x<<16,sc[sp3[j]].y<<16,sc[sp1[j]].x<<16,sc[sp1[j]].y<<16,(char)templong);
						}
				}
			break;
		case 2:
			dasprinum = 0;
			for(i=headspritesect[sectnum];i>=0;i=nextspritesect[i])
			{
				o = spri[i].objnum;
				dax = so[o].x+spri[i].x-globx;
				day = so[o].y+spri[i].y-globy;
				daz = so[o].z+spri[i].z-globz;
					//Perpendicular distance
				if (tmulscale28(dax,rc[2],day,rc[5],daz,rc[8]) >= 0)
				{
						//Euclidian distance
					objdist[dasprinum] = tmulscale8(dax,dax,day,day,daz,daz);
					objsort[dasprinum] = i;
					dasprinum++;
				}
			}

			gap = (dasprinum>>1);
			do
			{
				for(i=0;i<dasprinum-gap;i++)
				{
					temp = i;
					while ((objdist[temp] > objdist[temp+gap]) && (temp >= 0))
					{
						templong = objsort[temp]; objsort[temp] = objsort[temp+gap]; objsort[temp+gap] = templong;
						templong = objdist[temp]; objdist[temp] = objdist[temp+gap]; objdist[temp+gap] = templong;
						temp -= gap;
					}
				}
				gap >>= 1;
			} while (gap > 0);

			for(ii=dasprinum-1;ii>=0;ii--)
			{
				i = objsort[ii];
				if ((spri[i].xscale != 0) && (spri[i].yscale != 0) && (spri[i].zscale != 0))
				{
					o = spri[i].objnum;
					xvect = so[o].x+spri[i].x-globx;
					yvect = so[o].y+spri[i].y-globy;
					zvect = so[o].z+spri[i].z-globz;
					rotate3d(&xvect,&yvect,&zvect);
					addrotate3d(spri[i].a1,spri[i].a2,spri[i].a3,rc,i);
					k = 0;
					for(j=pointoff[o];j<pointoff[o+1];j++)
					{
						dax = sp[j].x; day = sp[j].y; daz = sp[j].z;
						rotate3d(&dax,&day,&daz);
						dax += xvect; day += yvect; daz += zvect;
						if (daz > 4)
							projectlo(dax,day,daz,&sc[k].x,&sc[k].y);
						else
							sc[k].x = 0x80000000;
						k++;
					}
					setuprotate3d(spri[i].a1,spri[i].a2,spri[i].a3,rc);
					x = 65536*1024; y = 65536*3072; z = 65536*1024;
					rotate3d(&x,&y,&z);
					copybuf(rc2,rc,9);

					for(j=planeoff[o];j<planeoff[o+1];j++)
						if (sc[sp1[j]].x != 0x80000000)
							if (sc[sp2[j]].x != 0x80000000)
								if (sc[sp3[j]].x != 0x80000000)
								{
									dashade = tmulscale28(sn[j].x,x,sn[j].y,y,sn[j].z,z);
									dashade = (dashade>>11)+(objdist[ii]>>18)+(j&1)+12;
									if (dashade < 0) dashade = 0;
									if (dashade > 31) dashade = 31;
									drawsolidtri(j,(long)palookup[dashade][((i&7)<<5)+31]);
								}
				}
			}
			break;
	}
}

projectlo (long x, long y, long z, long *dasx, long *dasy)
{
	long t;

	t = divscale8(xreszoom,z);
	*dasx = mulscale24(x,t) + (xdimup15>>16);
	*dasy = mulscale24(y,t) + (ydimup15>>16);
}

drawsolidtri(long i, long col)
{
	long v, nextv, z[3], upoint, dpoint, uval, dval;
	long x1, y1, x2, y2, dax1, day1, dax2, day2;
	long x, y, xplc, xinc;

	z[0] = sp3[i]; z[1] = sp2[i]; z[2] = sp1[i];

	if ((sc[z[1]].x-sc[z[0]].x)*(sc[z[2]].y-sc[z[0]].y) >= (sc[z[1]].y-sc[z[0]].y)*(sc[z[2]].x-sc[z[0]].x))
	{
		col &= 255;
		col += (col<<8);
		col += (col<<16);

		upoint = 0; dpoint = 0;
		uval = sc[z[0]].y; dval = uval;
		if (sc[z[1]].y < uval) upoint = 1, uval = sc[z[1]].y;
		if (sc[z[1]].y > dval) dpoint = 1, dval = sc[z[1]].y;
		if (sc[z[2]].y < uval) upoint = 2, uval = sc[z[2]].y;
		if (sc[z[2]].y > dval) dpoint = 2, dval = sc[z[2]].y;

		if ((dval < 0) || (uval > ydim)) return;

		v = dpoint;

		x2 = sc[z[v]].x;
		y2 = sc[z[v]].y;
		do
		{
			nextv = v+1; if (nextv == 3) nextv = 0;

			x1 = x2; y1 = y2;
			x2 = sc[z[nextv]].x; y2 = sc[z[nextv]].y;

			day1 = y1; if (day1 > ydim) day1 = ydim;
			day2 = y2; if (day2 < 0) day2 = 0;
			if (day1 > day2)
			{
				xinc = divscale16(x1-x2,y1-y2);
				xplc = (x2<<16);
				if (day2 != y2) xplc += (day2-y2)*xinc;
				qinterpolatedown16((long)(&lastx[day2]),day1-day2,xplc,xinc);
			}

			v = nextv;
		} while (v != upoint);

		do
		{
			nextv = v+1; if (nextv == 3) nextv = 0;

			x1 = x2; y1 = y2;
			x2 = sc[z[nextv]].x; y2 = sc[z[nextv]].y;

			day1 = y1; if (day1 < 0) day1 = 0;
			day2 = y2; if (day2 > ydim) day2 = ydim;
			if (y2 > y1)
			{
				xinc = divscale16(x2-x1,y2-y1);
				xplc = (x1<<16);
				if (day1 != y1) xplc += (day1-y1)*xinc;
				for(y=day1;y<day2;y++)
				{
					dax1 = lastx[y]; if (dax1 < 0) dax1 = 0;
					dax2 = (xplc>>16); if (dax2 > xdim) dax2 = xdim;
					if (dax2 > dax1)
						clearbufbyte(frameplace+ylookup[y]+dax1,dax2-dax1,col);
					xplc += xinc;
				}
			}

			v = nextv;
		} while (v != dpoint);
	}
}

getregion(long x, long y, long z)
{
	long i, j, k;

	i = head;
	while (1)
	{
		j = lin[linoff[i]]; k = 0;
		if (plane[i].normal.x != 0) k += mulscale8(plane[i].normal.x,x-p[j].x);
		if (plane[i].normal.y != 0) k += mulscale8(plane[i].normal.y,y-p[j].y);
		if (plane[i].normal.z != 0) k += mulscale8(plane[i].normal.z,z-p[j].z);
		if (k <= 0)
		{
			j = plane[i].front;
			if (j < 0) return(i);
			i = j;
		}
		else
		{
			j = plane[i].back;
			if (j < 0) return(i+MAXPLANES);
			i = j;
		}
	}
	return(-1);
}

initspritelists()
{
	long i;

	for (i=0;i<MAXREGIONS;i++)     //Init doubly-linked sprite sector lists
		headspritesect[i] = -1;
	headspritesect[MAXREGIONS] = 0;
	for(i=0;i<MAXSPRITES;i++)
	{
		prevspritesect[i] = i-1;
		nextspritesect[i] = i+1;
		spri[i].sectnum = MAXREGIONS;
	}
	prevspritesect[0] = -1;
	nextspritesect[MAXSPRITES-1] = -1;


	for(i=0;i<MAXSTATUS;i++)      //Init doubly-linked sprite status lists
		headspritestat[i] = -1;
	headspritestat[MAXSTATUS] = 0;
	for(i=0;i<MAXSPRITES;i++)
	{
		prevspritestat[i] = i-1;
		nextspritestat[i] = i+1;
		spri[i].statnum = MAXSTATUS;
	}
	prevspritestat[0] = -1;
	nextspritestat[MAXSPRITES-1] = -1;
}

insertsprite(short sectnum, short statnum)
{
	insertspritestat(statnum);
	return(insertspritesect(sectnum));
}

insertspritesect(short sectnum)
{
	short blanktouse;

	if ((sectnum < 0) || (sectnum >= MAXREGIONS) || (headspritesect[MAXREGIONS] == -1))
		return(-1);  //list full

	blanktouse = headspritesect[MAXREGIONS];

	headspritesect[MAXREGIONS] = nextspritesect[blanktouse];
	if (headspritesect[MAXREGIONS] >= 0)
		prevspritesect[headspritesect[MAXREGIONS]] = -1;

	prevspritesect[blanktouse] = -1;
	nextspritesect[blanktouse] = headspritesect[sectnum];
	if (headspritesect[sectnum] >= 0)
		prevspritesect[headspritesect[sectnum]] = blanktouse;
	headspritesect[sectnum] = blanktouse;

	spri[blanktouse].sectnum = sectnum;

	return(blanktouse);
}

insertspritestat(short statnum)
{
	short blanktouse;

	if ((statnum < 0) || (statnum >= MAXSTATUS) || (headspritestat[MAXSTATUS] == -1))
		return(-1);  //list full

	blanktouse = headspritestat[MAXSTATUS];

	headspritestat[MAXSTATUS] = nextspritestat[blanktouse];
	if (headspritestat[MAXSTATUS] >= 0)
		prevspritestat[headspritestat[MAXSTATUS]] = -1;

	prevspritestat[blanktouse] = -1;
	nextspritestat[blanktouse] = headspritestat[statnum];
	if (headspritestat[statnum] >= 0)
		prevspritestat[headspritestat[statnum]] = blanktouse;
	headspritestat[statnum] = blanktouse;

	spri[blanktouse].statnum = statnum;

	return(blanktouse);
}

deletesprite(short spritenum)
{
	deletespritestat(spritenum);
	return(deletespritesect(spritenum));
}

deletespritesect(short deleteme)
{
	if (spri[deleteme].sectnum == MAXREGIONS)
		return(-1);

	if (headspritesect[spri[deleteme].sectnum] == deleteme)
		headspritesect[spri[deleteme].sectnum] = nextspritesect[deleteme];

	if (prevspritesect[deleteme] >= 0) nextspritesect[prevspritesect[deleteme]] = nextspritesect[deleteme];
	if (nextspritesect[deleteme] >= 0) prevspritesect[nextspritesect[deleteme]] = prevspritesect[deleteme];

	if (headspritesect[MAXREGIONS] >= 0) prevspritesect[headspritesect[MAXREGIONS]] = deleteme;
	prevspritesect[deleteme] = -1;
	nextspritesect[deleteme] = headspritesect[MAXREGIONS];
	headspritesect[MAXREGIONS] = deleteme;

	spri[deleteme].sectnum = MAXREGIONS;
	return(0);
}

deletespritestat (short deleteme)
{
	if (spri[deleteme].statnum == MAXSTATUS)
		return(-1);

	if (headspritestat[spri[deleteme].statnum] == deleteme)
		headspritestat[spri[deleteme].statnum] = nextspritestat[deleteme];

	if (prevspritestat[deleteme] >= 0) nextspritestat[prevspritestat[deleteme]] = nextspritestat[deleteme];
	if (nextspritestat[deleteme] >= 0) prevspritestat[nextspritestat[deleteme]] = prevspritestat[deleteme];

	if (headspritestat[MAXSTATUS] >= 0) prevspritestat[headspritestat[MAXSTATUS]] = deleteme;
	prevspritestat[deleteme] = -1;
	nextspritestat[deleteme] = headspritestat[MAXSTATUS];
	headspritestat[MAXSTATUS] = deleteme;

	spri[deleteme].statnum = MAXSTATUS;
	return(0);
}

changespritesect(short spritenum, short newsectnum)
{
	if ((newsectnum < 0) || (newsectnum > MAXREGIONS)) return(-1);
	if (spri[spritenum].sectnum == newsectnum) return(-1);
	if (spri[spritenum].sectnum == MAXREGIONS) return(-1);
	if (deletespritesect(spritenum) < 0) return(-1);
	insertspritesect(newsectnum);
	return(0);
}

changespritestat(short spritenum, short newstatnum)
{
	if ((newstatnum < 0) || (newstatnum > MAXSTATUS)) return(-1);
	if (spri[spritenum].statnum == newstatnum) return(-1);
	if (spri[spritenum].statnum == MAXSTATUS) return(-1);
	if (deletespritestat(spritenum) < 0) return(-1);
	insertspritestat(newstatnum);
	return(0);
}

initmouse()
{
	if ((setupandgetmouseirq()&65535) == 0) return(0);
	switch(mouseirq)
	{
		case 3: mouseport = 0x2f8; break;
		case 4: mouseport = 0x3f8; break;
		default: mouseirq = 4; mouseport = 0x3f8; break;
	}
	oldmousehandler = _dos_getvect(mouseirq+0x8);
	_disable(); _dos_setvect(mouseirq+0x8, mousehandler); _enable();
	return(1);
}

uninitmouse()
{
	if (mouseport <= 0) return;
	_disable(); _dos_setvect(mouseirq+0x8, oldmousehandler); _enable();
}

void __interrupt __far mousehandler()
{
	mousetemp = inp(mouseport); if (mousetemp&0x40) mousebytecnt = 0;
	mousebyte[mousebytecnt++] = mousetemp;
	if (mousebytecnt > 2)
	{
		mousebytecnt = 0;
		intmousx += ((signed char)((mousebyte[0]<<6)&192)+(mousebyte[1]&63));
		intmousy += ((signed char)((mousebyte[0]<<4)&192)+(mousebyte[2]&63));
		intbstatus = mouselookup[(mousebyte[0]>>4)&3];
	}
	outp(0x20,0x20);
}

getmousevalues(short *mousx, short *mousy, short *bstatus)
{
	if (mouseport <= 0)
	{
		*mousx = 0;
		*mousy = 0;
		*bstatus = 0;
		return;
	}
	*mousx = intmousx; intmousx -= *mousx;
	*mousy = intmousy; intmousy -= *mousy;
	*bstatus = intbstatus;
}

setdrawmode(char newdrawmode)
{
	drawmode = newdrawmode;
	switch(drawmode)
	{
		case 0: globdrawplanefunction = drawfasttextureplane; break;
		case 1: globdrawplanefunction = drawslowtextureplane; break;
		case 2: globdrawplanefunction = drawsolidplane; break;
		case 3: globdrawplanefunction = drawwireplane; break;
	}
}

void drawfasttextureplane(long npoints)
{
	long i, j, z, zz, x, y, x1, y1, x2, y2, d1, d2, dapicnum;
	long plc, inc, minx, maxx, miny, maxy, c1, c2;

	dapicnum = globtext+animateoffs(globtext);
	if (waloff[dapicnum] == 0) loadtile(dapicnum);
	if (waloff[dapicnum] == 0) return;

	setupgetreadpos();

	if (klabs(getdxinc) <= klabs(getdyinc))
	{
		if (keystatus[0x38]) return;
		if (getdxinc == 0)
			globm = 0;
		else
		{
			globm = divscale16(getdxinc,getdyinc);   //d& = y& + mulscale&(x&, m&, 16)
			if (klabs(globm) < 64) globm = 0;
			if (globm > 65536-128) globm = 65536;
			if (globm < -65536+128) globm = -65536;
		}

		z = picsiz[dapicnum];
		i = (256<<(z&15))+(1<<(z>>4))-257; j = ((z&15)<<8)+(z>>4);
		if (globm == 0)
		{
			if ((globstat&2) == 0)
				setuphline(waloff[dapicnum],i,j);
			else
				msetuphline(waloff[dapicnum],i,j);
		}
		else
		{
			if ((globstat&2) == 0)
				setupdline(waloff[dapicnum],i,j);
			else
				msetupdline(waloff[dapicnum],i,j);
		}

		globuadd = getuxinc-mulscale16(globm,getuyinc);
		globvadd = getvxinc-mulscale16(globm,getvyinc);
		globdax >>= 16;

		for(z=npoints-1;z>=0;z--) sc[z].x += 65535;

		minx = sc[0].x; maxx = sc[0].x;
		for(z=npoints-1;z>0;z--)
		{
			x = sc[z].x;
			if (x < minx) minx = x;
			if (x > maxx) maxx = x;
		}
		minx >>= 16; maxx >>= 16;

		if (globm > 0)
			qinterpolatedown16(&hplc[minx],maxx-minx+1,0L,globm);
		else
			qinterpolatedown16(&hplc[minx],maxx-minx+1,xdim<<16,globm);

		if (globm != 0)
		{
			if (globm < 0) i = xdim; else i = -xdim;
			for(x=minx;x<=maxx;x++)
			{
				haddtable[x] = 1;
				if (hplc[x] != hplc[x+1]) haddtable[x] += i;
			}
			haddtable[maxx] = 0;
		}

		miny = 0x7fffffff; maxy = 0x80000000;
		for(z=npoints-1;z>=0;z--)
		{
			y = (sc[z].y>>16) + hplc[sc[z].x>>16];
			if (y < miny) miny = y;
			if (y > maxy) maxy = y;
		}
		miny--; maxy++;

		c1 = 1; clearbuf(&h1[miny],((maxy+1-miny)+1)>>1,0L);
		c2 = 1; clearbuf(&h2[miny],((maxy+1-miny)+1)>>1,0L);

		for(z=npoints-1;z>=0;z--)
		{
			zz = point2[z];
			x1 = sc[z].x; y1 = sc[z].y; x2 = sc[zz].x; y2 = sc[zz].y;

			if (((x1^x2)&0xffff0000) == 0)
			{
				x = (x1>>16);
				y = (y1>>16) + hplc[x];
				j = (y2>>16) + hplc[x];
				while (j < y) { p1[c1] = x; n1[c1] = h1[y]; h1[y] = c1; c1++; y--; }
				while (j > y) { y++; p2[c2] = x; n2[c2] = h2[y]; h2[y] = c2; c2++; }
			}
			else
			{
				if ((klabs(y2-y1)>>15) < klabs(x2-x1))
					inc = divscale16(y2-y1,x2-x1);
				else
					inc = 0;

				d1 = (x1>>16); d2 = (x2>>16);
				if (x1 < x2)
				{
					plc = y1 + mulscale16((-x1)&65535,inc);
					y = (y1>>16) + hplc[d1];
					for(x=d1;x<d2;x++)
					{
						j = (plc>>16) + hplc[x]; plc += inc;
						while (j < y) { p1[c1] = x; n1[c1] = h1[y]; h1[y] = c1; c1++; y--; }
						while (j > y) { y++; p2[c2] = x; n2[c2] = h2[y]; h2[y] = c2; c2++; }
					}
					j = (y2>>16) + hplc[d2];
					while (j < y) { p1[c1] = x; n1[c1] = h1[y]; h1[y] = c1; c1++; y--; }
					while (j > y) { y++; p2[c2] = x; n2[c2] = h2[y]; h2[y] = c2; c2++; }
				}
				else
				{
					plc = y2 + mulscale16((-x2)&65535,inc);
					y = (y2>>16) + hplc[d2];
					for(x=d2;x<d1;x++)
					{
						j = (plc>>16) + hplc[x]; plc += inc;
						while (j < y) { p2[c2] = x; n2[c2] = h2[y]; h2[y] = c2; c2++; y--; }
						while (j > y) { y++; p1[c1] = x; n1[c1] = h1[y]; h1[y] = c1; c1++; }
					}
					j = (y1>>16) + hplc[d1];
					while (j < y) { p2[c2] = x; n2[c2] = h2[y]; h2[y] = c2; c2++; y--; }
					while (j > y) { y++; p1[c1] = x; n1[c1] = h1[y]; h1[y] = c1; c1++; }
				}
			}
		}

		for(y=miny;y<=maxy;y++)
			for(y1=h1[y],y2=h2[y];y1!=0;y1=n1[y1],y2=n2[y2])
			{
				d1 = y1; d2 = y2;
				for(i=n1[y1],j=n2[y2];i!=0;i=n1[i],j=n2[j])
				{
					if (p1[i] < p1[d1]) d1 = i;
					if (p2[j] < p2[d2]) d2 = j;
				}
				if (p1[d1] < p2[d2]) diaghline(p1[d1],p2[d2]-1,y);
				p1[d1] = p1[y1]; p2[d2] = p2[y2];
			}
	}
	else
	{
		if (keystatus[0xb8]) return;
		if (getdyinc == 0)
			globm = 0;
		else
		{
			globm = divscale16(getdyinc,getdxinc);
			if (klabs(globm) < 64) globm = 0;
			if (globm > 65536-128) globm = 65536;
			if (globm < -65536+128) globm = -65536;
		}

		z = picsiz[dapicnum];
		i = (256<<(z&15))+(1<<(z>>4))-257; j = ((z&15)<<8)+(z>>4);
		if (globm == 0)
		{
			if ((globstat&2) == 0)
				setupvline(waloff[dapicnum],i,j);
			else
				msetupvline(waloff[dapicnum],i,j);
		}
		else
		{
			if ((globstat&2) == 0)
				setupdline(waloff[dapicnum],i,j);
			else
				msetupdline(waloff[dapicnum],i,j);
		}

		globuadd = getuyinc-mulscale16(globm,getuxinc);
		globvadd = getvyinc-mulscale16(globm,getvxinc);
		globday >>= 16;

		for(z=npoints-1;z>=0;z--) sc[z].y += 65535;

		miny = sc[0].y; maxy = sc[0].y;
		for(z=npoints-1;z>0;z--)
		{
			y = sc[z].y;
			if (y < miny) miny = y;
			if (y > maxy) maxy = y;
		}
		miny >>= 16; maxy >>= 16;

		if (globm > 0)
			qinterpolatedown16(&hplc[miny],maxy-miny+1,0L,globm);
		else
			qinterpolatedown16(&hplc[miny],maxy-miny+1,xdim<<16,globm);

		if (globm != 0)
		{
			if (globm < 0) i = 1; else i = -1;
			for(y=miny;y<maxy;y++)
			{
				haddtable[y] = xdim;
				if (hplc[y] != hplc[y+1]) haddtable[y] += i;
			}
			haddtable[maxy] = 0;
		}

		minx = 0x7fffffff; maxx = 0x80000000;
		for(z=npoints-1;z>=0;z--)
		{
			x = (sc[z].x>>16) + hplc[sc[z].y>>16];
			if (x < minx) minx = x;
			if (x > maxx) maxx = x;
		}
		minx--; maxx++;

		c1 = 1; clearbuf(&h1[minx],((maxx+1-minx)+1)>>1,0L);
		c2 = 1; clearbuf(&h2[minx],((maxx+1-minx)+1)>>1,0L);

		for(z=npoints-1;z>=0;z--)
		{
			zz = point2[z];
			x1 = sc[z].x; y1 = sc[z].y; x2 = sc[zz].x; y2 = sc[zz].y;

			if (((y1^y2)&0xffff0000) == 0)
			{
				y = (y1>>16);
				x = (x1>>16) + hplc[y];
				j = (x2>>16) + hplc[y];
				while (j < x) { p1[c1] = y; n1[c1] = h1[x]; h1[x] = c1; c1++; x--; }
				while (j > x) { x++; p2[c2] = y; n2[c2] = h2[x]; h2[x] = c2; c2++; }
			}
			else
			{
				if ((klabs(x2-x1)>>15) < klabs(y2-y1))
					inc = divscale16(x2-x1,y2-y1);
				else
					inc = 0;

				d1 = (y1>>16); d2 = (y2>>16);
				if (y1 < y2)
				{
					plc = x1 + mulscale16((-y1)&65535,inc);
					x = (x1>>16) + hplc[d1];
					for(y=d1;y<d2;y++)
					{
						j = (plc>>16) + hplc[y]; plc += inc;
						while (j < x) { p1[c1] = y; n1[c1] = h1[x]; h1[x] = c1; c1++; x--; }
						while (j > x) { x++; p2[c2] = y; n2[c2] = h2[x]; h2[x] = c2; c2++; }
					}
					j = (x2>>16) + hplc[d2];
					while (j < x) { p1[c1] = y; n1[c1] = h1[x]; h1[x] = c1; c1++; x--; }
					while (j > x) { x++; p2[c2] = y; n2[c2] = h2[x]; h2[x] = c2; c2++; }
				}
				else
				{
					plc = x2 + mulscale16((-y2)&65535,inc);
					x = (x2>>16) + hplc[d2];
					for(y=d2;y<d1;y++)
					{
						j = (plc>>16) + hplc[y]; plc += inc;
						while (j < x) { p2[c2] = y; n2[c2] = h2[x]; h2[x] = c2; c2++; x--; }
						while (j > x) { x++; p1[c1] = y; n1[c1] = h1[x]; h1[x] = c1; c1++; }
					}
					j = (x1>>16) + hplc[d1];
					while (j < x) { p2[c2] = y; n2[c2] = h2[x]; h2[x] = c2; c2++; x--; }
					while (j > x) { x++; p1[c1] = y; n1[c1] = h1[x]; h1[x] = c1; c1++; }
				}
			}
		}

		for(x=minx;x<=maxx;x++)
			for(x1=h1[x],x2=h2[x];x1!=0;x1=n1[x1],x2=n2[x2])
			{
				d1 = x1; d2 = x2;
				for(i=n1[x1],j=n2[x2];i!=0;i=n1[i],j=n2[j])
				{
					if (p1[i] < p1[d1]) d1 = i;
					if (p2[j] < p2[d2]) d2 = j;
				}
				if (p2[d2] < p1[d1]) diagvline(p2[d2],p1[d1]-1,x);
				p1[d1] = p1[x1]; p2[d2] = p2[x2];
			}
	}
}

krand()
{
	randomseed = ((randomseed*21+1)&65535);
	return(randomseed);
}
