#include <i86.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>

#ifdef ENGINE     //Make variables defined in ENGINE and externed in GAME
	#define EXTERN
#else
	#define EXTERN extern
#endif

#define MAXXDIM 1600
#define MAXYDIM 1200

#define MAXTILES 4096
#define MAXTILEFILES 256
#define MAXPALOOKUPS 64
#define MAXPOINTS 8192
#define MAXLINES 32768
#define MAXPLANES 8192
#define MAXREGIONS (MAXPLANES<<1)
#define MAXGROUPS 1024
#define MAXSTATUS 1024

#define MAXSPOINTS 4096
#define MAXSPLANES 4096
#define MAXSOBJECTS 256
#define MAXSPRIS 4096

#define reduce(x,y,z,val)                                  \
{                                                          \
	while (klabs(x) >= (val<<3)) x >>= 4, y >>= 4, z >>= 4; \
	while (klabs(y) >= (val<<3)) x >>= 4, y >>= 4, z >>= 4; \
	while (klabs(z) >= (val<<3)) x >>= 4, y >>= 4, z >>= 4; \
	while (klabs(x) >= val) x >>= 1, y >>= 1, z >>= 1;      \
	while (klabs(y) >= val) x >>= 1, y >>= 1, z >>= 1;      \
	while (klabs(z) >= val) x >>= 1, y >>= 1, z >>= 1;      \
}

typedef struct
{
	long x, y;
} point2d;

typedef struct
{
	long x, y, z;
} point3d;

typedef struct
{
	long ox, oy, oz, ux, uy, uz, vx, vy, vz;
	point3d normal;
	point3d min, max;
	short plist, parent, front, back;
	short dat, next, prev;
	short texture;
	signed char shade;
	char palookup, flags; //Flags: D0=Parallax, D1=Maskable, D2=Walk-through
} planetype;

typedef struct
{
	long x, y, z;
	long a1, a2, a3;
	short xvel, yvel, zvel;
	short a1vel, a2vel, a3vel;
	short objnum, stat;
	short sectnum, statnum;
	char xscale, yscale, zscale;
	short lotag, hitag, extra;
} spritype;

	//Screen mode variables
EXTERN char *screen, reversemode, spritedrawmode;
EXTERN long frameplace, visualpage, stereopage, stereowidth;

	//Board variables
EXTERN planetype plane[MAXPLANES];
EXTERN short numplanes, numlines, numpoints, head;    //BSP tree head
EXTERN point3d p[MAXPOINTS], r[MAXPOINTS], r2[MAXPOINTS], ri[MAXPOINTS];
EXTERN point2d sc[MAXPOINTS];
EXTERN short lin[MAXLINES], lin2[MAXLINES];
EXTERN short linoff[MAXPLANES], linnum[MAXPLANES];

	//Polygon Sprite variables
EXTERN spritype spri[MAXSPRIS];
EXTERN long snumpoints, snumplanes, snumobjects, snumgroups;
EXTERN point3d sp[MAXSPOINTS];
EXTERN short sp1[MAXSPLANES], sp2[MAXSPLANES], sp3[MAXSPLANES];
EXTERN point3d sn[MAXSPLANES], so[MAXSOBJECTS];
EXTERN short planeoff[MAXSOBJECTS], pointoff[MAXSOBJECTS];
EXTERN short groupoff[MAXGROUPS];
	//Sprite lists in sectors/status
EXTERN short headspritesect[MAXREGIONS+1], headspritestat[MAXSTATUS+1];
EXTERN short prevspritesect[MAXSPRIS], prevspritestat[MAXSPRIS];
EXTERN short nextspritesect[MAXSPRIS], nextspritestat[MAXSPRIS];

	//Tiles???.ART variables
EXTERN char *pic, picsiz[MAXTILES];        //pic-pointer to BIG tile buffer
EXTERN long numtiles, waloff[MAXTILES], picanm[MAXTILES];  //waloff-offset
EXTERN long tilesizx[MAXTILES], tilesizy[MAXTILES];    //dimensions of tile
	//Palette variables
EXTERN short numpalookups;
EXTERN char palette[768], whitecol, blackcol;
EXTERN char palookup[MAXPALOOKUPS][256], *transluc;

	//Handy lookup tables
EXTERN short sintable[2048];   //sintable[ang] = 16384*sin(ang*3.141592/1024)
EXTERN long ylookup[MAXYDIM];  //ylookup[y] = y*xdim;
EXTERN long randomseed;

	//Temp variables - Save memory by using these (Polytex uses them also)
EXTERN char tempbuf[4096];
EXTERN short tempshort[MAXTILES];

	//Mouse variables
EXTERN short mousx, mousy, bstatus, obstatus, moustat;
EXTERN long searchx, searchy;

	//Interrupt variables
EXTERN volatile long totalclock;      //Tic counter - you should increment
EXTERN volatile char keystatus[256];  //Status (0/1) of each key by scan code
